/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Collection;
import java.util.Iterator;
import jscl.math.Arithmetic;
import jscl.math.Expression;
import jscl.math.Field;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLBoolean;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.ModularInteger;
import jscl.math.NotDivisibleException;
import jscl.math.Rational;
import jscl.math.Variable;
import jscl.math.polynomial.ArrayPolynomial;
import jscl.math.polynomial.ArrayPolynomialBoolean;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.ArrayPolynomialInteger;
import jscl.math.polynomial.ArrayPolynomialModular;
import jscl.math.polynomial.ArrayPolynomialRational;
import jscl.math.polynomial.DefinedBooleanMonomial;
import jscl.math.polynomial.GeoBucket;
import jscl.math.polynomial.ListPolynomial;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.NestedPolynomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Term;
import jscl.math.polynomial.TreePolynomial;
import jscl.math.polynomial.UnivariatePolynomial;
import jscl.mathml.MathML;

public abstract class Polynomial
implements Arithmetic,
Comparable {
    final Monomial monomialFactory;
    final Generic coefFactory;
    final Ordering ordering;
    final boolean defined;
    final boolean field;
    boolean normalized;
    int sugar;
    int index = -1;

    Polynomial(Monomial monomialFactory, Generic coefFactory) {
        this.monomialFactory = monomialFactory;
        this.coefFactory = coefFactory;
        this.ordering = monomialFactory.ordering();
        this.defined = monomialFactory instanceof DefinedBooleanMonomial;
        this.field = coefFactory instanceof Field;
    }

    public abstract int size();

    public Ordering ordering() {
        return this.ordering;
    }

    public final Iterator iterator() {
        return this.iterator(false);
    }

    public final Iterator iterator(boolean direction) {
        return this.iterator(direction, null);
    }

    public final Iterator iterator(Monomial current) {
        return this.iterator(true, current);
    }

    public abstract Iterator iterator(boolean var1, Monomial var2);

    public Polynomial add(Polynomial polynomial) {
        return this.multiplyAndSubtract(this.coefficient(JSCLInteger.valueOf(-1L)), polynomial);
    }

    public abstract Polynomial subtract(Polynomial var1);

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        return this.subtract(polynomial.multiply(generic));
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        return this.subtract(polynomial.multiply(monomial).multiply(generic));
    }

    public Polynomial multiply(Polynomial polynomial) {
        Polynomial p = this.valueof(JSCLInteger.valueOf(0L));
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Term t = (Term)it.next();
            p = p.multiplyAndSubtract(t.monomial(), t.coef().negate(), polynomial);
        }
        return p;
    }

    public abstract Polynomial multiply(Generic var1);

    public abstract Polynomial multiply(Monomial var1);

    public boolean multiple(Polynomial polynomial) throws ArithmeticException {
        return this.remainder(polynomial).signum() == 0;
    }

    public Polynomial divide(Polynomial polynomial) throws ArithmeticException {
        Polynomial[] p = this.divideAndRemainder(polynomial);
        if (p[1].signum() == 0) {
            return p[0];
        }
        throw new NotDivisibleException();
    }

    public abstract Polynomial divide(Generic var1) throws ArithmeticException;

    public abstract Polynomial divide(Monomial var1) throws ArithmeticException;

    @Override
    public Arithmetic add(Arithmetic arithmetic) {
        return this.add((Polynomial)arithmetic);
    }

    @Override
    public Arithmetic subtract(Arithmetic arithmetic) {
        return this.subtract((Polynomial)arithmetic);
    }

    @Override
    public Arithmetic multiply(Arithmetic arithmetic) {
        return this.multiply((Polynomial)arithmetic);
    }

    @Override
    public Arithmetic divide(Arithmetic arithmetic) throws ArithmeticException {
        return this.divide((Polynomial)arithmetic);
    }

    public Polynomial[] divideAndRemainder(Polynomial polynomial) throws ArithmeticException {
        Polynomial[] p = new Polynomial[]{this.valueof(JSCLInteger.valueOf(0L)), this};
        Polynomial q = polynomial;
        Iterator it = p[1].iterator(true);
        while (it.hasNext()) {
            Monomial m2;
            Term t = (Term)it.next();
            Monomial m1 = t.monomial();
            if (!m1.multiple(m2 = q.head().monomial())) continue;
            Monomial m = m1.divide(m2);
            Generic c1 = t.coef();
            Generic c2 = q.head().coef();
            Generic c = c1.divide(c2);
            p[0] = p[0].multiplyAndSubtract(m, c, this.valueof(JSCLInteger.valueOf(-1L)));
            p[1] = p[1].multiplyAndSubtract(m, c, q);
            it = p[1].iterator(true);
        }
        return p;
    }

    public Polynomial remainder(Polynomial polynomial) throws ArithmeticException {
        return this.divideAndRemainder(polynomial)[1];
    }

    public Polynomial remainderUpToCoefficient(Polynomial polynomial) throws ArithmeticException {
        Polynomial p = this;
        Polynomial q = polynomial;
        Iterator it = p.iterator(true);
        while (it.hasNext()) {
            Monomial m2;
            Term t = (Term)it.next();
            Monomial m1 = t.monomial();
            if (!m1.multiple(m2 = q.head().monomial())) continue;
            Monomial m = m1.divide(m2);
            Generic c1 = t.coef();
            Generic c2 = q.head().coef();
            p = p.multiply(c2).multiplyAndSubtract(m, c1, q);
            it = p.iterator(true);
        }
        return p;
    }

    public abstract Polynomial gcd(Polynomial var1);

    public Polynomial scm(Polynomial polynomial) {
        return this.divide(this.gcd(polynomial)).multiply(polynomial);
    }

    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        Generic a = this.coefficient(JSCLInteger.valueOf(0L));
        Iterator it = this.iterator();
        while (it.hasNext()) {
            a = a.gcd(((Term)it.next()).coef());
        }
        return a.signum() == this.signum() ? a : a.negate();
    }

    public final Polynomial[] gcdAndNormalize() {
        Generic gcd = this.gcd();
        return new Polynomial[]{this.valueof(gcd), gcd.signum() == 0 ? this : this.divide(gcd)};
    }

    public final Polynomial normalize() {
        if (this.normalized) {
            return this;
        }
        Polynomial p = this.gcdAndNormalize()[1];
        p.normalized = true;
        return p;
    }

    public Monomial monomialGcd() {
        Monomial m = this.monomial(this.tail());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            m = m.gcd(((Term)it.next()).monomial());
        }
        return m;
    }

    public Polynomial pow(int exponent) {
        Polynomial a = this.valueof(JSCLInteger.valueOf(1L));
        for (int i = 0; i < exponent; ++i) {
            a = a.multiply(this);
        }
        return a;
    }

    public Polynomial abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public Polynomial negate() {
        return this.multiply(this.coefficient(JSCLInteger.valueOf(-1L)));
    }

    public final int signum() {
        return this.coefficient(this.tail()).signum();
    }

    static int degree(Polynomial polynomial) {
        return polynomial.monomial(polynomial.head()).degree();
    }

    public abstract int degree();

    public abstract Polynomial valueof(Polynomial var1);

    public abstract Polynomial valueof(Generic var1);

    public abstract Polynomial valueof(Monomial var1);

    public final Polynomial copy() {
        return this.valueof(this);
    }

    public abstract Polynomial freeze();

    public Term head() {
        Iterator it = this.iterator(true);
        return it.hasNext() ? (Term)it.next() : null;
    }

    public Term tail() {
        Iterator it = this.iterator();
        return it.hasNext() ? (Term)it.next() : null;
    }

    public Generic coefficient(Monomial monomial) {
        Iterator it = this.iterator(false, monomial);
        Term t = it.hasNext() ? (Term)it.next() : null;
        return this.coefficient(t == null || this.ordering.compare(t.monomial(), monomial) == 0 ? t : null);
    }

    Monomial monomial(Term term) {
        return term == null ? this.monomial(Literal.valueOf()) : term.monomial();
    }

    Generic coefficient(Term term) {
        return term == null ? this.coefficient(JSCLInteger.valueOf(0L)) : term.coef();
    }

    protected Monomial monomial(Literal literal) {
        return this.monomialFactory.valueof(literal);
    }

    protected Generic coefficient(Generic generic) {
        return this.coefFactory == null ? generic : this.coefFactory.valueof(generic);
    }

    public Polynomial reduce(Collection ideal, boolean tail) {
        Iterator it;
        Polynomial p = this;
        Iterator iterator = it = tail ? p.iterator(p.head().monomial()) : p.iterator(true);
        block0: while (it.hasNext()) {
            Term t = (Term)it.next();
            Monomial m1 = t.monomial();
            for (Polynomial q : ideal) {
                Monomial m2 = q.head().monomial();
                if (!m1.multiple(m2)) continue;
                Monomial m = m1.divide(m2);
                p = p.reduce(t.coef(), m, q);
                it = tail ? p.iterator(m1) : p.iterator(true);
                continue block0;
            }
            tail = true;
        }
        return p;
    }

    public Polynomial reduce(Generic generic, Monomial monomial, Polynomial polynomial) {
        if (this.field) {
            return this.multiplyAndSubtract(monomial, generic.divide(polynomial.head().coef()), polynomial);
        }
        Generic c1 = generic;
        Generic c2 = polynomial.head().coef();
        Generic c = c1.gcd(c2);
        c1 = c1.divide(c);
        c2 = c2.divide(c);
        return this.multiply(c2).multiplyAndSubtract(monomial, c1, polynomial).normalize();
    }

    public Polynomial reduce(Generic generic, Polynomial polynomial) {
        return this.reduce(generic, this.monomial(Literal.valueOf()), polynomial);
    }

    public int sugar() {
        return this.sugar;
    }

    public int index() {
        return this.index;
    }

    public void setSugar(int n) {
        this.sugar = n;
    }

    public void setIndex(int n) {
        if (this.index != -1) {
            throw new ArithmeticException();
        }
        this.index = n;
    }

    public Generic genericValue() {
        Generic s = JSCLInteger.valueOf(0L);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Term t = (Term)it.next();
            Monomial m = t.monomial();
            Expression a = t.coef().expressionValue();
            s = ((Generic)s).add(m.degree() > 0 ? ((Generic)a).multiply(Expression.valueOf(m.literalValue())) : a);
        }
        return s;
    }

    public Generic[] elements() {
        int size = this.size();
        Generic[] a = new Generic[size];
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = ((Term)it.next()).coef();
        }
        return a;
    }

    public static Polynomial factory(Variable variable) {
        return new UnivariatePolynomial(variable);
    }

    public static Polynomial factory(Variable[] variable) {
        return new NestedPolynomial(variable);
    }

    public static Polynomial factory(Variable[] unknown, Ordering ordering) {
        return Polynomial.factory(unknown, ordering, 0);
    }

    public static Polynomial factory(Variable[] unknown, Ordering ordering, int modulo) {
        return Polynomial.factory(unknown, ordering, modulo, 0);
    }

    public static Polynomial factory(Variable[] unknown, Ordering ordering, int modulo, int flags) {
        return Polynomial.factory(Monomial.factory(unknown, ordering, flags & 0x30), modulo, flags & 3, (flags & 0x40) > 0);
    }

    static Polynomial factory(Monomial monomialFactory, int modulo, int data_struct, boolean buckets) {
        if (buckets) {
            return new GeoBucket(Polynomial.factory(monomialFactory, modulo, data_struct, false));
        }
        switch (data_struct) {
            case 1: {
                return new ArrayPolynomial(monomialFactory, Polynomial.generic(modulo));
            }
            case 2: {
                return new TreePolynomial(monomialFactory, Polynomial.generic(modulo));
            }
            case 3: {
                return new ListPolynomial(monomialFactory, Polynomial.generic(modulo));
            }
        }
        switch (modulo) {
            case -1: {
                return new ArrayPolynomialGeneric(monomialFactory, null);
            }
            case 0: {
                return new ArrayPolynomialInteger(monomialFactory);
            }
            case 1: {
                return new ArrayPolynomialRational(monomialFactory);
            }
            case 2: {
                return new ArrayPolynomialBoolean(monomialFactory);
            }
        }
        return new ArrayPolynomialModular(monomialFactory, ModularInteger.factory(modulo));
    }

    static Generic generic(int modulo) {
        switch (modulo) {
            case -1: {
                return null;
            }
            case 0: {
                return JSCLInteger.factory;
            }
            case 1: {
                return Rational.factory;
            }
            case 2: {
                return JSCLBoolean.factory;
            }
        }
        return ModularInteger.factory(modulo);
    }

    static Polynomial factory(Polynomial polynomial, int modulo) {
        Monomial m = polynomial.monomialFactory;
        return Polynomial.factory(m.unknown(), m.ordering(), modulo);
    }

    public int compareTo(Polynomial polynomial) {
        Term t2;
        Iterator it1 = this.iterator(true);
        Iterator it2 = polynomial.iterator(true);
        Term t1 = it1.hasNext() ? (Term)it1.next() : null;
        Term term = t2 = it2.hasNext() ? (Term)it2.next() : null;
        while (t1 != null || t2 != null) {
            int c;
            int n = t1 == null ? 1 : (c = t2 == null ? -1 : this.ordering.compare(t1.monomial(), t2.monomial()));
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            c = t1.coef().compareTo(t2.coef());
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            t1 = it1.hasNext() ? (Term)it1.next() : null;
            t2 = it2.hasNext() ? (Term)it2.next() : null;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((Polynomial)o);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Polynomial) {
            return this.compareTo((Polynomial)obj) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.signum() == 0) {
            buffer.append("0");
        }
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Term t = (Term)it.next();
            Monomial m = t.monomial();
            Generic a = t.coef();
            if (a instanceof Expression) {
                Generic generic = a = a.signum() > 0 ? GenericVariable.valueOf(a).expressionValue() : GenericVariable.valueOf(a.negate()).expressionValue().negate();
            }
            if (a.signum() > 0 && i > 0) {
                buffer.append("+");
            }
            if (m.degree() == 0) {
                buffer.append(a);
            } else {
                if (a.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                    if (a.signum() < 0) {
                        buffer.append("-");
                    }
                } else {
                    buffer.append(a).append("*");
                }
                buffer.append(m);
            }
            ++i;
        }
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        MathML e1 = element.element("mrow");
        if (this.signum() == 0) {
            MathML e2 = element.element("mn");
            e2.appendChild(element.text("0"));
            e1.appendChild(e2);
        }
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MathML e2;
            Term t = (Term)it.next();
            Monomial m = t.monomial();
            Generic a = t.coef();
            if (a instanceof Expression) {
                Generic generic = a = a.signum() > 0 ? GenericVariable.valueOf(a).expressionValue() : GenericVariable.valueOf(a.negate()).expressionValue().negate();
            }
            if (a.signum() > 0 && i > 0) {
                e2 = element.element("mo");
                e2.appendChild(element.text("+"));
                e1.appendChild(e2);
            }
            if (m.degree() == 0) {
                Expression.separateSign(e1, a);
            } else {
                if (a.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                    if (a.signum() < 0) {
                        e2 = element.element("mo");
                        e2.appendChild(element.text("-"));
                        e1.appendChild(e2);
                    }
                } else {
                    Expression.separateSign(e1, a);
                }
                m.toMathML(e1, null);
            }
            ++i;
        }
        element.appendChild(e1);
    }
}

