/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.trigonometric;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Log;
import jscl.math.function.Trigonometric;
import jscl.math.function.trigonometric.Acot;
import jscl.math.function.trigonometric.Cos;
import jscl.math.function.trigonometric.Sin;

public class Cot
extends Trigonometric {
    public Cot(Generic generic) {
        super("cot", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Log(JSCLInteger.valueOf(4L).multiply(new Sin(this.parameter[0]).evaluate())).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L).add(new Cot(this.parameter[0]).evaluate().pow(2)).negate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Cot(this.parameter[0].negate()).evaluate().negate();
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Frac(new Cos(this.parameter[0]).evalelem(), new Sin(this.parameter[0]).evalelem()).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Cot(this.parameter[0].negate()).evaluate().negate();
        }
        try {
            Variable v = this.parameter[0].variableValue();
            if (v instanceof Acot) {
                Generic[] g = ((Acot)v).parameters();
                return g[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic a, Generic b) {
        Generic ta = new Cot(a).evalsimp();
        Generic tb = new Cot(b).evalsimp();
        return new Frac(ta.multiply(tb).subtract(JSCLInteger.valueOf(1L)), ta.add(tb)).evalsimp();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).cot();
    }

    @Override
    protected Variable newinstance() {
        return new Cot(null);
    }
}

