/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Abs;
import jscl.math.function.Frac;
import jscl.math.function.Function;

public class Sgn
extends Function {
    public Sgn(Generic generic) {
        super("sgn", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Abs(this.parameter[0]).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Sgn(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(1L);
        }
        try {
            return JSCLInteger.valueOf(this.parameter[0].integerValue().signum());
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        return new Frac(this.parameter[0], new Abs(this.parameter[0]).evalelem()).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Sgn(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(1L);
        }
        try {
            return JSCLInteger.valueOf(this.parameter[0].integerValue().signum());
        }
        catch (NotIntegerException notIntegerException) {
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Abs) {
                    return JSCLInteger.valueOf(1L);
                }
                if (v instanceof Sgn) {
                    Function f = (Function)v;
                    return f.evalsimp();
                }
            }
            catch (NotVariableException notVariableException) {
                // empty catch block
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).sgn();
    }

    @Override
    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".sgn()");
        return buffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Sgn(null);
    }
}

