/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Log;
import jscl.math.function.NotRootException;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;
import jscl.mathml.MathML;

public class Pow
extends Algebraic {
    public Pow(Generic generic, Generic exponent) {
        super("pow", new Generic[]{generic, exponent});
    }

    @Override
    public Root rootValue() throws NotRootException {
        block6: {
            try {
                Variable v = this.parameter[1].variableValue();
                if (!(v instanceof Inv)) break block6;
                Generic g = ((Inv)v).parameter();
                try {
                    int d = g.integerValue().intValue();
                    if (d > 0) {
                        Generic[] a = new Generic[d + 1];
                        a[0] = this.parameter[0].negate();
                        for (int i = 1; i < d; ++i) {
                            a[i] = JSCLInteger.valueOf(0L);
                        }
                        a[d] = JSCLInteger.valueOf(1L);
                        return new Root(a, 0);
                    }
                }
                catch (NotIntegerException notIntegerException) {}
            }
            catch (NotVariableException notVariableException) {
                // empty catch block
            }
        }
        throw new NotRootException();
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        try {
            Root r = this.rootValue();
            Generic[] g = r.parameters();
            if (g[0].isPolynomial(variable)) {
                return Antiderivative.compute(r, variable);
            }
            throw new NotIntegrableException();
        }
        catch (NotRootException notRootException) {
            return super.antiderivative(variable);
        }
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        if (n == 0) {
            return new Pow(this.parameter[0], this.parameter[1].add(JSCLInteger.valueOf(1L))).evaluate().multiply(new Inv(this.parameter[1].add(JSCLInteger.valueOf(1L))).evaluate());
        }
        return new Pow(this.parameter[0], this.parameter[1]).evaluate().multiply(new Inv(new Log(this.parameter[0]).evaluate()).evaluate());
    }

    @Override
    public Generic derivative(int n) {
        if (n == 0) {
            return new Pow(this.parameter[0], this.parameter[1].subtract(JSCLInteger.valueOf(1L))).evaluate().multiply(this.parameter[1]);
        }
        return new Pow(this.parameter[0], this.parameter[1]).evaluate().multiply(new Log(this.parameter[0]).evaluate());
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return JSCLInteger.valueOf(1L);
        }
        if (this.parameter[1].signum() < 0) {
            return new Pow(new Inv(this.parameter[0]).evaluate(), this.parameter[1].negate()).evaluate();
        }
        try {
            int c = this.parameter[1].integerValue().intValue();
            return this.parameter[0].pow(c);
        }
        catch (NotIntegerException c) {
            try {
                Root r = this.rootValue();
                int d = r.degree();
                Generic[] g = r.parameters();
                Generic a = g[0].negate();
                try {
                    JSCLInteger rt;
                    JSCLInteger en = a.integerValue();
                    if (en.signum() >= 0 && ((Generic)(rt = en.nthrt(d))).pow(d).compareTo(en) == 0) {
                        return rt;
                    }
                }
                catch (NotIntegerException notIntegerException) {}
            }
            catch (NotRootException notRootException) {
                // empty catch block
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        return new Exp(new Log(this.parameter[0]).evalelem().multiply(this.parameter[1])).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return JSCLInteger.valueOf(1L);
        }
        if (this.parameter[1].signum() < 0) {
            return new Pow(new Inv(this.parameter[0]).evalsimp(), this.parameter[1].negate()).evalsimp();
        }
        try {
            int c = this.parameter[1].integerValue().intValue();
            return this.parameter[0].pow(c);
        }
        catch (NotIntegerException c) {
            block13: {
                try {
                    Root r = this.rootValue();
                    int d = r.degree();
                    Generic[] g = r.parameters();
                    Generic a = g[0].negate();
                    try {
                        JSCLInteger rt;
                        JSCLInteger en = a.integerValue();
                        if (en.signum() >= 0 && ((Generic)(rt = en.nthrt(d))).pow(d).compareTo(en) == 0) {
                            return rt;
                        }
                    }
                    catch (NotIntegerException notIntegerException) {
                        // empty catch block
                    }
                    switch (d) {
                        case 2: {
                            return new Sqrt(a).evalsimp();
                        }
                        case 3: 
                        case 4: 
                        case 6: {
                            if (a.compareTo(JSCLInteger.valueOf(-1L)) != 0) break;
                            return Pow.root_minus_1(d);
                        }
                    }
                }
                catch (NotRootException e) {
                    Generic[] n = Frac.separateCoefficient(this.parameter[1]);
                    if (n[0].compareTo(JSCLInteger.valueOf(1L)) == 0 && n[1].compareTo(JSCLInteger.valueOf(1L)) == 0) break block13;
                    return new Pow(new Pow(new Pow(this.parameter[0], n[2]).evalsimp(), new Inv(n[1]).evalsimp()).evalsimp(), n[0]).evalsimp();
                }
            }
            return this.expressionValue();
        }
    }

    static Generic root_minus_1(int d) {
        switch (d) {
            case 1: {
                return JSCLInteger.valueOf(-1L);
            }
            case 2: {
                return Constant.i;
            }
            case 3: {
                return Constant.jbar.negate();
            }
            case 4: {
                return new Sqrt(Constant.half).expressionValue().multiply(JSCLInteger.valueOf(1L).add(Constant.i));
            }
            case 6: {
                return Constant.half.multiply(new Sqrt(JSCLInteger.valueOf(3L)).expressionValue().add(Constant.i));
            }
        }
        return null;
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).pow((NumericWrapper)this.parameter[1]);
    }

    @Override
    public String toString() {
        Variable v;
        JSCLInteger en;
        StringBuffer buffer = new StringBuffer();
        try {
            en = this.parameter[0].integerValue();
            if (en.signum() < 0) {
                buffer.append(GenericVariable.valueOf(en, true));
            } else {
                buffer.append(en);
            }
        }
        catch (NotIntegerException e) {
            try {
                v = this.parameter[0].variableValue();
                if (v instanceof Frac || v instanceof Pow) {
                    buffer.append(GenericVariable.valueOf(this.parameter[0]));
                } else {
                    buffer.append(v);
                }
            }
            catch (NotVariableException e2) {
                try {
                    Power o = this.parameter[0].powerValue();
                    if (o.exponent() == 1) {
                        buffer.append(o.value(true));
                    } else {
                        buffer.append(GenericVariable.valueOf(this.parameter[0]));
                    }
                }
                catch (NotPowerException e3) {
                    buffer.append(GenericVariable.valueOf(this.parameter[0]));
                }
            }
        }
        buffer.append("^");
        try {
            en = this.parameter[1].integerValue();
            buffer.append(en);
        }
        catch (NotIntegerException e) {
            try {
                v = this.parameter[1].variableValue();
                if (v instanceof Frac) {
                    buffer.append(GenericVariable.valueOf(this.parameter[1]));
                } else {
                    buffer.append(v);
                }
            }
            catch (NotVariableException e2) {
                try {
                    this.parameter[1].powerValue();
                    buffer.append(this.parameter[1]);
                }
                catch (NotPowerException e3) {
                    buffer.append(GenericVariable.valueOf(this.parameter[1]));
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".pow(");
        buffer.append(this.parameter[1].toJava());
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    void bodyToMathML(MathML element, boolean fenced) {
        if (fenced) {
            MathML e1 = element.element("mfenced");
            this.bodyToMathML(e1);
            element.appendChild(e1);
        } else {
            this.bodyToMathML(element);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("msup");
        try {
            Variable v = this.parameter[0].variableValue();
            if (v instanceof Frac || v instanceof Pow || v instanceof Exp) {
                GenericVariable.valueOf(this.parameter[0]).toMathML(e1, null);
            } else {
                this.parameter[0].toMathML(e1, null);
            }
        }
        catch (NotVariableException e2) {
            try {
                Power o = this.parameter[0].powerValue();
                if (o.exponent() == 1) {
                    o.value(true).toMathML(e1, null);
                } else {
                    GenericVariable.valueOf(this.parameter[0]).toMathML(e1, null);
                }
            }
            catch (NotPowerException e3) {
                GenericVariable.valueOf(this.parameter[0]).toMathML(e1, null);
            }
        }
        this.parameter[1].toMathML(e1, null);
        element.appendChild(e1);
    }

    @Override
    protected Variable newinstance() {
        return new Pow(null, null);
    }
}

