/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.NotDivisibleException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Inv;
import jscl.math.function.Root;
import jscl.mathml.MathML;

public class Frac
extends Algebraic {
    public Frac(Generic numerator, Generic denominator) {
        super("frac", new Generic[]{numerator, denominator});
    }

    @Override
    public Root rootValue() {
        return new Root(new Generic[]{this.parameter[0].negate(), this.parameter[1]}, 0);
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        if (this.parameter[0].isPolynomial(variable) && this.parameter[1].isPolynomial(variable)) {
            return Antiderivative.compute(this, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        if (n == 0) {
            return new Inv(this.parameter[1]).evaluate();
        }
        return this.parameter[0].multiply(new Inv(this.parameter[1]).evaluate().pow(2).negate());
    }

    public boolean integer() {
        try {
            this.parameter[0].integerValue().intValue();
            this.parameter[1].integerValue().intValue();
            return true;
        }
        catch (NotIntegerException notIntegerException) {
            return false;
        }
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return new Inv(this.parameter[1]).evaluate();
        }
        try {
            return this.parameter[0].divide(this.parameter[1]);
        }
        catch (NotDivisibleException notDivisibleException) {
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Frac(this.parameter[0].negate(), this.parameter[1]).evalsimp().negate();
        }
        if (this.parameter[1].signum() < 0) {
            return new Frac(this.parameter[0].negate(), this.parameter[1].negate()).evalsimp();
        }
        return this.evaluate();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).divide((NumericWrapper)this.parameter[1]);
    }

    static Generic[] separateCoefficient(Generic generic) {
        if (generic.signum() < 0) {
            Generic[] n = Frac.separateCoefficient(generic.negate());
            return new Generic[]{n[0], n[1], n[2].negate()};
        }
        try {
            Variable v = generic.variableValue();
            if (v instanceof Frac) {
                Generic[] g = ((Frac)v).parameters();
                Expression a = g[0].expressionValue();
                Expression d = g[1].expressionValue();
                Generic[] na = a.gcdAndNormalize();
                Generic[] nd = d.gcdAndNormalize();
                return new Generic[]{na[0], nd[0], new Frac(na[1], nd[1]).evaluate()};
            }
        }
        catch (NotVariableException e) {
            try {
                Expression a = generic.expressionValue();
                Generic[] n = a.gcdAndNormalize();
                return new Generic[]{n[0], JSCLInteger.valueOf(1L), n[1]};
            }
            catch (NotExpressionException notExpressionException) {
                // empty catch block
            }
        }
        return new Generic[]{JSCLInteger.valueOf(1L), JSCLInteger.valueOf(1L), generic};
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            this.parameter[0].powerValue();
            buffer.append(this.parameter[0]);
        }
        catch (NotPowerException e) {
            buffer.append(GenericVariable.valueOf(this.parameter[0]));
        }
        buffer.append("/");
        try {
            Variable v = this.parameter[1].variableValue();
            if (v instanceof Frac) {
                buffer.append(GenericVariable.valueOf(this.parameter[1]));
            } else {
                buffer.append(v);
            }
        }
        catch (NotVariableException e) {
            try {
                this.parameter[1].abs().powerValue();
                buffer.append(this.parameter[1]);
            }
            catch (NotPowerException e2) {
                buffer.append(GenericVariable.valueOf(this.parameter[1]));
            }
        }
        return buffer.toString();
    }

    @Override
    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".divide(");
        buffer.append(this.parameter[1].toJava());
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    void bodyToMathML(MathML element, boolean fenced) {
        if (fenced) {
            MathML e1 = element.element("mfenced");
            this.bodyToMathML(e1);
            element.appendChild(e1);
        } else {
            this.bodyToMathML(element);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("mfrac");
        this.parameter[0].toMathML(e1, null);
        this.parameter[1].toMathML(e1, null);
        element.appendChild(e1);
    }

    @Override
    protected Variable newinstance() {
        return new Frac(null, null);
    }
}

