/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;

public class TechnicalVariable
extends Variable {
    public int[] subscript;

    public TechnicalVariable(String name) {
        this(name, new int[0]);
    }

    public TechnicalVariable(String name, int[] subscript) {
        super(name);
        this.subscript = subscript;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        if (this.isIdentity(variable)) {
            return generic;
        }
        return this.expressionValue();
    }

    @Override
    public Generic expand() {
        return this.expressionValue();
    }

    @Override
    public Generic factorize() {
        return this.expressionValue();
    }

    @Override
    public Generic elementary() {
        return this.expressionValue();
    }

    @Override
    public Generic simplify() {
        return this.expressionValue();
    }

    @Override
    public Generic numeric() {
        throw new ArithmeticException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return !this.isIdentity(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        TechnicalVariable v = (TechnicalVariable)variable;
        c = this.name.compareTo(v.name);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return this.compareSubscript(this.subscript, v.subscript);
    }

    public int compareSubscript(int[] c1, int[] c2) {
        if (c1.length < c2.length) {
            return -1;
        }
        if (c1.length > c2.length) {
            return 1;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] < c2[i]) {
                return -1;
            }
            if (c1[i] <= c2[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        if (this.subscript.length == 1) {
            buffer.append(this.subscript[0]);
        } else {
            for (int i = 0; i < this.subscript.length; ++i) {
                buffer.append("[").append(this.subscript[i]).append("]");
            }
        }
        return buffer.toString();
    }

    @Override
    public String toJava() {
        return null;
    }

    public String toMathML(Object data) {
        return null;
    }

    @Override
    protected Variable newinstance() {
        return new TechnicalVariable(this.name);
    }
}

