/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.ExpressionVariable;
import jscl.math.Generic;
import jscl.math.IntegerVariable;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.Variable;
import jscl.mathml.MathML;

public abstract class GenericVariable
extends Variable {
    Generic content;

    GenericVariable(Generic generic) {
        super("");
        this.content = generic;
    }

    public static Generic content(Generic generic) {
        return GenericVariable.content(generic, false);
    }

    public static Generic content(Generic generic, boolean expression) {
        try {
            Variable v = generic.variableValue();
            if (expression) {
                if (v instanceof ExpressionVariable) {
                    generic = ((ExpressionVariable)v).content;
                }
            } else if (v instanceof GenericVariable) {
                generic = ((GenericVariable)v).content;
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return generic;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return this.content.antiderivative(variable);
    }

    @Override
    public Generic derivative(Variable variable) {
        return this.content.derivative(variable);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        GenericVariable v = (GenericVariable)this.newinstance();
        v.content = this.content.substitute(variable, generic);
        if (v.isIdentity(variable)) {
            return generic;
        }
        return v.expressionValue();
    }

    @Override
    public Generic expand() {
        return this.content.expand();
    }

    @Override
    public Generic factorize() {
        GenericVariable v = (GenericVariable)this.newinstance();
        v.content = this.content.factorize();
        return v.expressionValue();
    }

    @Override
    public Generic elementary() {
        GenericVariable v = (GenericVariable)this.newinstance();
        v.content = this.content.elementary();
        return v.expressionValue();
    }

    @Override
    public Generic simplify() {
        GenericVariable v = (GenericVariable)this.newinstance();
        v.content = this.content.simplify();
        return v.expressionValue();
    }

    @Override
    public Generic numeric() {
        return this.content.numeric();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return this.content.isConstant(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        GenericVariable v = (GenericVariable)variable;
        return this.content.compareTo(v.content);
    }

    public static GenericVariable valueOf(Generic generic) {
        return GenericVariable.valueOf(generic, false);
    }

    public static GenericVariable valueOf(Generic generic, boolean integer) {
        if (integer) {
            return new IntegerVariable(generic);
        }
        return new ExpressionVariable(generic);
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    @Override
    public String toJava() {
        return this.content.toJava();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        this.content.toMathML(element, data);
    }
}

