/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.IntLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LogicLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.ObjectLargeArray;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.StringLargeArray;
import pl.edu.icm.jlargearrays.UnsignedByteLargeArray;
import sun.misc.Unsafe;

public class LargeArrayUtils {
    public static final Unsafe UNSAFE;

    private LargeArrayUtils() {
    }

    public static void arraycopy(Object src, long srcPos, Object dest, long destPos, long length) {
        if (src instanceof LargeArray && dest instanceof LargeArray) {
            LargeArrayUtils.arraycopy((LargeArray)src, srcPos, (LargeArray)dest, destPos, length);
        } else if (src instanceof LargeArray) {
            LargeArrayUtils.arraycopy((LargeArray)src, srcPos, dest, (int)destPos, (int)length);
        } else if (dest instanceof LargeArray) {
            LargeArrayUtils.arraycopy(src, (int)srcPos, (LargeArray)dest, destPos, (int)length);
        } else {
            System.arraycopy(src, (int)srcPos, dest, (int)destPos, (int)length);
        }
    }

    private static void arraycopy(LargeArray src, long srcPos, LargeArray dest, long destPos, long length) {
        if (src.getType() != dest.getType()) {
            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
        }
        switch (src.getType()) {
            case LOGIC: {
                LargeArrayUtils.arraycopy((LogicLargeArray)src, srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                LargeArrayUtils.arraycopy((ByteLargeArray)src, srcPos, (ByteLargeArray)dest, destPos, length);
                break;
            }
            case UNSIGNED_BYTE: {
                LargeArrayUtils.arraycopy((UnsignedByteLargeArray)src, srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                LargeArrayUtils.arraycopy((ShortLargeArray)src, srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                LargeArrayUtils.arraycopy((IntLargeArray)src, srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                LargeArrayUtils.arraycopy((LongLargeArray)src, srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                LargeArrayUtils.arraycopy((FloatLargeArray)src, srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                LargeArrayUtils.arraycopy((DoubleLargeArray)src, srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                LargeArrayUtils.arraycopy((ComplexFloatLargeArray)src, srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                LargeArrayUtils.arraycopy((ComplexDoubleLargeArray)src, srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                LargeArrayUtils.arraycopy((StringLargeArray)src, srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                LargeArrayUtils.arraycopy((ObjectLargeArray)src, srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    private static void arraycopy(Object src, int srcPos, LargeArray dest, long destPos, int length) {
        Class<?> dataClass = src.getClass();
        Class<?> componentClass = dataClass.getComponentType();
        switch (dest.getType()) {
            case LOGIC: {
                if (componentClass == Boolean.TYPE) {
                    LargeArrayUtils.arraycopy((boolean[])src, srcPos, (LogicLargeArray)dest, destPos, length);
                    break;
                }
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((byte[])src, srcPos, (LogicLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case BYTE: {
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((byte[])src, srcPos, (ByteLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case UNSIGNED_BYTE: {
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((byte[])src, srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                    break;
                }
                if (componentClass == Short.TYPE) {
                    LargeArrayUtils.arraycopy((short[])src, srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case SHORT: {
                if (componentClass == Short.TYPE) {
                    LargeArrayUtils.arraycopy((short[])src, srcPos, (ShortLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case INT: {
                if (componentClass == Integer.TYPE) {
                    LargeArrayUtils.arraycopy((int[])src, srcPos, (IntLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case LONG: {
                if (componentClass == Long.TYPE) {
                    LargeArrayUtils.arraycopy((long[])src, srcPos, (LongLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case FLOAT: {
                if (componentClass == Float.TYPE) {
                    LargeArrayUtils.arraycopy((float[])src, srcPos, (FloatLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case DOUBLE: {
                if (componentClass == Double.TYPE) {
                    LargeArrayUtils.arraycopy((double[])src, srcPos, (DoubleLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case COMPLEX_FLOAT: {
                if (componentClass == Float.TYPE) {
                    LargeArrayUtils.arraycopy((float[])src, srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case COMPLEX_DOUBLE: {
                if (componentClass == Double.TYPE) {
                    LargeArrayUtils.arraycopy((double[])src, srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case STRING: {
                if (src instanceof String[]) {
                    LargeArrayUtils.arraycopy((String[])src, srcPos, (StringLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case OBJECT: {
                if (src instanceof Object[]) {
                    LargeArrayUtils.arraycopy((Object[])src, srcPos, (ObjectLargeArray)dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    private static void arraycopy(LargeArray src, long srcPos, Object dest, int destPos, int length) {
        Class<?> dataClass = dest.getClass();
        Class<?> componentClass = dataClass.getComponentType();
        switch (src.getType()) {
            case LOGIC: {
                if (componentClass == Boolean.TYPE) {
                    LargeArrayUtils.arraycopy((LogicLargeArray)src, srcPos, (boolean[])dest, destPos, length);
                    break;
                }
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((LogicLargeArray)src, srcPos, (byte[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case BYTE: {
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((ByteLargeArray)src, srcPos, (byte[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case UNSIGNED_BYTE: {
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((UnsignedByteLargeArray)src, srcPos, (byte[])dest, destPos, length);
                    break;
                }
                if (componentClass == Short.TYPE) {
                    LargeArrayUtils.arraycopy((UnsignedByteLargeArray)src, srcPos, (short[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case SHORT: {
                if (componentClass == Short.TYPE) {
                    LargeArrayUtils.arraycopy((ShortLargeArray)src, srcPos, (short[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case INT: {
                if (componentClass == Integer.TYPE) {
                    LargeArrayUtils.arraycopy((IntLargeArray)src, srcPos, (int[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case LONG: {
                if (componentClass == Long.TYPE) {
                    LargeArrayUtils.arraycopy((LongLargeArray)src, srcPos, (long[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case FLOAT: {
                if (componentClass == Float.TYPE) {
                    LargeArrayUtils.arraycopy((FloatLargeArray)src, srcPos, (float[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case DOUBLE: {
                if (componentClass == Double.TYPE) {
                    LargeArrayUtils.arraycopy((DoubleLargeArray)src, srcPos, (double[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case COMPLEX_FLOAT: {
                if (componentClass == Float.TYPE) {
                    LargeArrayUtils.arraycopy((ComplexFloatLargeArray)src, srcPos, (float[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case COMPLEX_DOUBLE: {
                if (componentClass == Double.TYPE) {
                    LargeArrayUtils.arraycopy((ComplexDoubleLargeArray)src, srcPos, (double[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case STRING: {
                if (dest instanceof String[]) {
                    LargeArrayUtils.arraycopy((StringLargeArray)src, srcPos, (String[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            case OBJECT: {
                if (dest instanceof Object[]) {
                    LargeArrayUtils.arraycopy((ObjectLargeArray)src, srcPos, (Object[])dest, destPos, length);
                    break;
                }
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    private static void arraycopy(final LogicLargeArray src, final long srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final boolean[] src, final int srcPos, final LogicLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setBoolean(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setBoolean(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setBoolean(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final byte[] src, final int srcPos, final LogicLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setByte(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final LogicLargeArray src, final long srcPos, final boolean[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getBoolean(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getBoolean(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getBoolean(j);
                }
            }
        }
    }

    private static void arraycopy(final LogicLargeArray src, final long srcPos, final byte[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getByte(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getByte(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getByte(j);
                }
            }
        }
    }

    private static void arraycopy(final ByteLargeArray src, final long srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final byte[] src, final int srcPos, final ByteLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setByte(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final ByteLargeArray src, final long srcPos, final byte[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getByte(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getByte(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getByte(j);
                }
            }
        }
    }

    private static void arraycopy(final UnsignedByteLargeArray src, final long srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final byte[] src, final int srcPos, final UnsignedByteLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setByte(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final short[] src, final int srcPos, final UnsignedByteLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setUnsignedByte(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setUnsignedByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setUnsignedByte(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final UnsignedByteLargeArray src, final long srcPos, final byte[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getByte(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getByte(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getByte(j);
                }
            }
        }
    }

    private static void arraycopy(final UnsignedByteLargeArray src, final long srcPos, final short[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getUnsignedByte(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getUnsignedByte(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getUnsignedByte(j);
                }
            }
        }
    }

    private static void arraycopy(final ShortLargeArray src, final long srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setShort(j, src.getShort(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setShort(destPos + k, src.getShort(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setShort(j, src.getShort(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final short[] src, final int srcPos, final ShortLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setShort(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setShort(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setShort(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final ShortLargeArray src, final long srcPos, final short[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getShort(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getShort(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getShort(j);
                }
            }
        }
    }

    private static void arraycopy(final IntLargeArray src, final long srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setInt(j, src.getInt(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setInt(destPos + k, src.getInt(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setInt(j, src.getInt(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final int[] src, final int srcPos, final IntLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setInt(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setInt(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setInt(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final IntLargeArray src, final long srcPos, final int[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getInt(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getInt(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getInt(j);
                }
            }
        }
    }

    private static void arraycopy(final LongLargeArray src, final long srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setLong(j, src.getLong(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setLong(destPos + k, src.getLong(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setLong(j, src.getLong(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final long[] src, final int srcPos, final LongLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setLong(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setLong(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setLong(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final LongLargeArray src, final long srcPos, final long[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getLong(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getLong(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getLong(j);
                }
            }
        }
    }

    private static void arraycopy(final FloatLargeArray src, final long srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setFloat(j, src.getFloat(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setFloat(destPos + k, src.getFloat(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setFloat(j, src.getFloat(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final float[] src, final int srcPos, final FloatLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setFloat(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setFloat(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setFloat(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final FloatLargeArray src, final long srcPos, final float[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getFloat(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getFloat(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getFloat(j);
                }
            }
        }
    }

    private static void arraycopy(final DoubleLargeArray src, final long srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setDouble(j, src.getDouble(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setDouble(destPos + k, src.getDouble(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setDouble(j, src.getDouble(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final double[] src, final int srcPos, final DoubleLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.setDouble(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setDouble(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.setDouble(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final DoubleLargeArray src, final long srcPos, final double[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.getDouble(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.getDouble(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.getDouble(j);
                }
            }
        }
    }

    private static void arraycopy(final ComplexFloatLargeArray src, final long srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setComplexFloat(j, src.getComplexFloat(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setComplexFloat(destPos + k, src.getComplexFloat(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setComplexFloat(j, src.getComplexFloat(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final float[] src, final int srcPos, final ComplexFloatLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + 2 * length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + 2 * length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            float[] elem = new float[2];
            for (long j = destPos; j < destPos + (long)length; ++j) {
                elem[0] = src[i];
                elem[1] = src[i + 1];
                dest.setComplexFloat(j, elem);
                i += 2;
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        int l = srcPos + (int)firstIdx;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            elem[0] = src[l];
                            elem[1] = src[l + 1];
                            dest.setComplexFloat(destPos + k, elem);
                            l += 2;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                float[] elem = new float[2];
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    elem[0] = src[i];
                    elem[1] = src[i + 1];
                    dest.setComplexFloat(j, elem);
                    i += 2;
                }
            }
        }
    }

    private static void arraycopy(final ComplexFloatLargeArray src, long srcPos, final float[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + 2 * length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + 2 * length > dest.length()");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                float[] elem = src.getComplexFloat(j);
                dest[i] = elem[0];
                dest[i + 1] = elem[1];
                i += 2;
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int l = destPos + (int)firstIdx;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            float[] elem = src.getComplexFloat(firstIdx + k);
                            dest[l] = elem[0];
                            dest[l + 1] = elem[1];
                            l += 2;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = (long)destPos; j < (long)(destPos + length); ++j) {
                    float[] elem = src.getComplexFloat(j);
                    dest[i] = elem[0];
                    dest[i + 1] = elem[1];
                    i += 2;
                }
            }
        }
    }

    private static void arraycopy(final ComplexDoubleLargeArray src, final long srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setComplexDouble(j, src.getComplexDouble(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setComplexDouble(destPos + k, src.getComplexDouble(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.setComplexDouble(j, src.getComplexDouble(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final double[] src, final int srcPos, final ComplexDoubleLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            double[] elem = new double[2];
            for (long j = destPos; j < destPos + (long)length; ++j) {
                elem[0] = src[i];
                elem[1] = src[i + 1];
                dest.setComplexDouble(j, elem);
                i += 2;
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        int l = srcPos + (int)firstIdx;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            elem[0] = src[l];
                            elem[1] = src[l + 1];
                            dest.setComplexDouble(destPos + k, elem);
                            l += 2;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                double[] elem = new double[2];
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    elem[0] = src[i];
                    elem[1] = src[i + 1];
                    dest.setComplexDouble(j, elem);
                    i += 2;
                }
            }
        }
    }

    private static void arraycopy(final ComplexDoubleLargeArray src, long srcPos, final double[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + 2 * length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + 2 * length > dest.length()");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                double[] elem = src.getComplexDouble(j);
                dest[i] = elem[0];
                dest[i + 1] = elem[1];
                i += 2;
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int l = destPos + (int)firstIdx;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double[] elem = src.getComplexDouble(firstIdx + k);
                            dest[l] = elem[0];
                            dest[l + 1] = elem[1];
                            l += 2;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = (long)destPos; j < (long)(destPos + length); ++j) {
                    double[] elem = src.getComplexDouble(j);
                    dest[i] = elem[0];
                    dest[i + 1] = elem[1];
                    i += 2;
                }
            }
        }
    }

    private static void arraycopy(final StringLargeArray src, final long srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.set(j, src.get(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src.get(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.set(j, src.get(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final String[] src, final int srcPos, final StringLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.set(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.set(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final StringLargeArray src, final long srcPos, final String[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.get(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.get(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.get(j);
                }
            }
        }
    }

    private static void arraycopy(final ObjectLargeArray src, final long srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0L || destPos + length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.set(j, src.get(i));
                ++i;
                ++j;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src.get(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                long i = srcPos;
                long j = destPos;
                while (i < srcPos + length) {
                    dest.set(j, src.get(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static void arraycopy(final Object[] src, final int srcPos, final ObjectLargeArray dest, final long destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0 || srcPos + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length");
        }
        if (destPos < 0L || destPos + (long)length > dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length()");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + (long)length; ++j) {
                dest.set(j, src[i++]);
            }
        } else {
            long k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? (long)length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = destPos; j < destPos + (long)length; ++j) {
                    dest.set(j, src[i++]);
                }
            }
        }
    }

    private static void arraycopy(final ObjectLargeArray src, final long srcPos, final Object[] dest, final int destPos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (srcPos < 0L || srcPos + (long)length > src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos + length > src.length()");
        }
        if (destPos < 0 || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos + length > dest.length");
        }
        int i = destPos;
        int nthreads = FastMath.min((int)length, (int)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || (long)length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = srcPos; j < srcPos + (long)length; ++j) {
                dest[i++] = src.get(j);
            }
        } else {
            int k = length / nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            dest[destPos + k] = src.get(srcPos + (long)k);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long j = srcPos; j < srcPos + (long)length; ++j) {
                    dest[i++] = src.get(j);
                }
            }
        }
    }

    private static boolean recomputeCopyLimits(long[] srcDim, long[] destDim, long[] srcPos, long[] destPos, long[] size) {
        for (int i = 0; i < srcDim.length; ++i) {
            if (srcPos[i] < 0L) {
                int n = i;
                size[n] = size[n] + srcPos[i];
                int n2 = i;
                destPos[n2] = destPos[n2] - srcPos[i];
                if (size[i] < 1L) {
                    return false;
                }
                srcPos[i] = 0L;
            }
            if (srcPos[i] + size[i] > srcDim[i]) {
                size[i] = srcDim[i] - srcPos[i];
                if (size[i] < 1L) {
                    return false;
                }
            }
            if (destPos[i] < 0L) {
                int n = i;
                size[n] = size[n] + destPos[i];
                int n3 = i;
                srcPos[n3] = srcPos[n3] - destPos[i];
                if (size[i] < 1L) {
                    return false;
                }
                destPos[i] = 0L;
            }
            if (destPos[i] + size[i] <= destDim[i]) continue;
            size[i] = destDim[i] - destPos[i];
            if (size[i] >= 1L) continue;
            return false;
        }
        return true;
    }

    private static long product(long[] a) {
        long p = 1L;
        for (int i = 0; i < a.length; ++i) {
            p *= a[i];
        }
        return p;
    }

    private static void checkArrayTypeAndSize(Object src, long[] srcDim, Object dest, long[] destDim) {
        block122: {
            Class<?> destComponentClass;
            Class<?> srcComponentClass;
            block124: {
                block123: {
                    block121: {
                        Class<?> srcDataClass = src.getClass();
                        srcComponentClass = srcDataClass.getComponentType();
                        Class<?> destDataClass = dest.getClass();
                        destComponentClass = destDataClass.getComponentType();
                        if (!(src instanceof LargeArray) || !(dest instanceof LargeArray)) break block121;
                        if (((LargeArray)src).getType() != ((LargeArray)dest).getType()) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != ((LargeArray)src).length()) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        if (LargeArrayUtils.product(destDim) != ((LargeArray)dest).length()) {
                            throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                        }
                        break block122;
                    }
                    if (!(src instanceof LargeArray)) break block123;
                    if (LargeArrayUtils.product(srcDim) != ((LargeArray)src).length()) {
                        throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                    }
                    switch (((LargeArray)src).getType()) {
                        case LOGIC: {
                            if (destComponentClass != Boolean.TYPE && destComponentClass != Byte.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (destComponentClass == Boolean.TYPE && LargeArrayUtils.product(destDim) != (long)((boolean[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            if (destComponentClass == Byte.TYPE && LargeArrayUtils.product(destDim) != (long)((byte[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case BYTE: {
                            if (destComponentClass != Byte.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((byte[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case UNSIGNED_BYTE: {
                            if (destComponentClass != Byte.TYPE && destComponentClass != Short.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (destComponentClass == Byte.TYPE && LargeArrayUtils.product(destDim) != (long)((byte[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            if (destComponentClass == Short.TYPE && LargeArrayUtils.product(destDim) != (long)((short[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case SHORT: {
                            if (destComponentClass != Short.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((short[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case INT: {
                            if (destComponentClass != Integer.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((int[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case LONG: {
                            if (destComponentClass != Long.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((long[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case FLOAT: {
                            if (destComponentClass != Float.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((float[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case DOUBLE: {
                            if (destComponentClass != Double.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((double[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case COMPLEX_FLOAT: {
                            if (destComponentClass != Float.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((float[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case COMPLEX_DOUBLE: {
                            if (destComponentClass != Double.TYPE) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((double[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case STRING: {
                            if (!(dest instanceof String[])) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((String[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        case OBJECT: {
                            if (!(dest instanceof Object[])) {
                                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                            }
                            if (LargeArrayUtils.product(destDim) != (long)((Object[])dest).length) {
                                throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                            }
                            break block122;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid array type.");
                        }
                    }
                }
                if (!(dest instanceof LargeArray)) break block124;
                if (LargeArrayUtils.product(destDim) != ((LargeArray)dest).length()) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
                switch (((LargeArray)dest).getType()) {
                    case LOGIC: {
                        if (srcComponentClass != Boolean.TYPE && srcComponentClass != Byte.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (srcComponentClass == Boolean.TYPE && LargeArrayUtils.product(srcDim) != (long)((boolean[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        if (srcComponentClass == Byte.TYPE && LargeArrayUtils.product(srcDim) != (long)((byte[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case BYTE: {
                        if (srcComponentClass != Byte.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((byte[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case UNSIGNED_BYTE: {
                        if (srcComponentClass != Byte.TYPE && srcComponentClass != Short.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (srcComponentClass == Byte.TYPE && LargeArrayUtils.product(srcDim) != (long)((byte[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        if (srcComponentClass == Short.TYPE && LargeArrayUtils.product(srcDim) != (long)((short[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case SHORT: {
                        if (srcComponentClass != Short.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((short[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case INT: {
                        if (srcComponentClass != Integer.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((int[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case LONG: {
                        if (srcComponentClass != Long.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((long[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case FLOAT: {
                        if (srcComponentClass != Float.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((float[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case DOUBLE: {
                        if (srcComponentClass != Double.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((double[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case COMPLEX_FLOAT: {
                        if (srcComponentClass != Float.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((float[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case COMPLEX_DOUBLE: {
                        if (srcComponentClass != Double.TYPE) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((double[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case STRING: {
                        if (!(src instanceof String[])) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((String[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    case OBJECT: {
                        if (!(src instanceof Object[])) {
                            throw new IllegalArgumentException("Types of source and destination arrays do not match.");
                        }
                        if (LargeArrayUtils.product(srcDim) != (long)((Object[])src).length) {
                            throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                        }
                        break block122;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            if (srcComponentClass == Boolean.TYPE && destComponentClass == Boolean.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((boolean[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((boolean[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (srcComponentClass == Byte.TYPE && destComponentClass == Byte.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((byte[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((byte[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (srcComponentClass == Short.TYPE && destComponentClass == Short.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((short[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((short[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (srcComponentClass == Integer.TYPE && destComponentClass == Integer.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((int[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((int[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (srcComponentClass == Long.TYPE && destComponentClass == Long.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((long[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((long[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (srcComponentClass == Float.TYPE && destComponentClass == Float.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((float[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((float[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (srcComponentClass == Double.TYPE && destComponentClass == Double.TYPE) {
                if (LargeArrayUtils.product(srcDim) != (long)((double[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((double[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (src instanceof String[] && dest instanceof String[]) {
                if (LargeArrayUtils.product(srcDim) != (long)((String[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((String[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else if (src instanceof Object[] && src instanceof Object[]) {
                if (LargeArrayUtils.product(srcDim) != (long)((Object[])src).length) {
                    throw new IllegalArgumentException("The length of source array does not match the source dimensions parameter.");
                }
                if (LargeArrayUtils.product(destDim) != (long)((Object[])dest).length) {
                    throw new IllegalArgumentException("The length of destimation array does not match the destimation dimensions parameter.");
                }
            } else {
                throw new IllegalArgumentException("Types of source and destination arrays do not match.");
            }
        }
    }

    public static void subarraycopy(Object src, long[] srcDim, long[] srcPos, Object dest, long[] destDim, long[] destPos, long[] size) {
        if (src == null || srcDim == null || srcPos == null || dest == null || destDim == null || destPos == null || size == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (srcDim.length != srcPos.length || srcDim.length != destDim.length || srcDim.length != destPos.length || srcDim.length != size.length) {
            throw new IllegalArgumentException("srcDim.length != srcPos.length || srcDim.length != destDim.length || srcDim.length != destPos || srcDim.length != size.length");
        }
        LargeArrayUtils.checkArrayTypeAndSize(src, srcDim, dest, destDim);
        long[] sp = (long[])srcPos.clone();
        long[] dp = (long[])destPos.clone();
        long[] s = (long[])size.clone();
        if (!LargeArrayUtils.recomputeCopyLimits(srcDim, destDim, sp, dp, s)) {
            throw new IllegalArgumentException("Invalid value in one of the parameters defining dimensions, positions and size.");
        }
        switch (srcDim.length) {
            case 4: {
                int r3 = 0;
                while ((long)r3 < s[3]) {
                    int r2 = 0;
                    while ((long)r2 < s[2]) {
                        int r1 = 0;
                        while ((long)r1 < s[1]) {
                            LargeArrayUtils.arraycopy(src, ((((long)r3 + sp[3]) * srcDim[2] + ((long)r2 + sp[2])) * srcDim[1] + (long)r1 + sp[1]) * srcDim[0] + sp[0], dest, ((((long)r3 + dp[3]) * destDim[2] + ((long)r2 + dp[2])) * destDim[1] + (long)r1 + dp[1]) * destDim[0] + dp[0], s[0]);
                            ++r1;
                        }
                        ++r2;
                    }
                    ++r3;
                }
                break;
            }
            case 3: {
                int r2 = 0;
                while ((long)r2 < s[2]) {
                    int r1 = 0;
                    while ((long)r1 < s[1]) {
                        LargeArrayUtils.arraycopy(src, (((long)r2 + sp[2]) * srcDim[1] + (long)r1 + sp[1]) * srcDim[0] + sp[0], dest, (((long)r2 + dp[2]) * destDim[1] + (long)r1 + dp[1]) * destDim[0] + dp[0], s[0]);
                        ++r1;
                    }
                    ++r2;
                }
                break;
            }
            case 2: {
                int r1 = 0;
                while ((long)r1 < s[1]) {
                    LargeArrayUtils.arraycopy(src, ((long)r1 + sp[1]) * srcDim[0] + sp[0], dest, ((long)r1 + dp[1]) * destDim[0] + dp[0], s[0]);
                    ++r1;
                }
                break;
            }
            case 1: {
                LargeArrayUtils.arraycopy(src, sp[0], dest, dp[0], s[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Arrays of rank greater than 4 are not supported.");
            }
        }
    }

    public static final void subarraycopy(Object src, int[] srcDim, int[] srcPos, Object dest, int[] destDim, int[] destPos, int[] size) {
        if (src == null || srcDim == null || srcPos == null || dest == null || destDim == null || destPos == null || size == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (srcDim.length != srcPos.length || srcDim.length != destDim.length || srcDim.length != destPos.length || srcDim.length != size.length) {
            throw new IllegalArgumentException("srcDim.length != srcPos.length || srcDim.length != destDim.length || srcDim.length != destPos || srcDim.length != size.length");
        }
        long[] srcDimLong = new long[srcDim.length];
        long[] srcPosLong = new long[srcDim.length];
        long[] destDimLong = new long[srcDim.length];
        long[] destPosLong = new long[srcDim.length];
        long[] sizeLong = new long[srcDim.length];
        for (int i = 0; i < srcDim.length; ++i) {
            srcDimLong[i] = srcDim[i];
            srcPosLong[i] = srcPos[i];
            destDimLong[i] = destDim[i];
            destPosLong[i] = destPos[i];
            sizeLong[i] = size[i];
        }
        LargeArrayUtils.subarraycopy(src, srcDimLong, srcPosLong, dest, destDimLong, destPosLong, sizeLong);
    }

    public static LargeArray createConstant(LargeArrayType type, long length, Object value) {
        switch (type) {
            case LOGIC: {
                byte v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (byte)1 : 0;
                } else if (value instanceof Byte) {
                    v = (Byte)value;
                } else if (value instanceof Short) {
                    v = ((Short)value).byteValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).byteValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).byteValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).byteValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).byteValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new LogicLargeArray(length, v, true);
            }
            case BYTE: {
                byte v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (byte)1 : 0;
                } else if (value instanceof Byte) {
                    v = (Byte)value;
                } else if (value instanceof Short) {
                    v = ((Short)value).byteValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).byteValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).byteValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).byteValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).byteValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new ByteLargeArray(length, v, true);
            }
            case UNSIGNED_BYTE: {
                short v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (short)1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).shortValue();
                } else if (value instanceof Short) {
                    v = (Short)value;
                } else if (value instanceof Integer) {
                    v = ((Integer)value).shortValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).shortValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).shortValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).shortValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new UnsignedByteLargeArray(length, v, true);
            }
            case SHORT: {
                short v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (short)1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).shortValue();
                } else if (value instanceof Short) {
                    v = (Short)value;
                } else if (value instanceof Integer) {
                    v = ((Integer)value).shortValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).shortValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).shortValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).shortValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new ShortLargeArray(length, v, true);
            }
            case INT: {
                int v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).intValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).intValue();
                } else if (value instanceof Integer) {
                    v = (Integer)value;
                } else if (value instanceof Long) {
                    v = ((Long)value).intValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).intValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).intValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new IntLargeArray(length, v, true);
            }
            case LONG: {
                long v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1L : 0L;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).longValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).longValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).longValue();
                } else if (value instanceof Long) {
                    v = (Long)value;
                } else if (value instanceof Float) {
                    v = ((Float)value).longValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).longValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new LongLargeArray(length, v, true);
            }
            case FLOAT: {
                float v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1.0f : 0.0f;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).floatValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).floatValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).floatValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).floatValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).floatValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).floatValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new FloatLargeArray(length, v, true);
            }
            case DOUBLE: {
                double v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1.0 : 0.0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).doubleValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).doubleValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).doubleValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).doubleValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).doubleValue();
                } else if (value instanceof Double) {
                    v = (Double)value;
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new DoubleLargeArray(length, v, true);
            }
            case COMPLEX_FLOAT: {
                Class<?> dataClass = value.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass != Float.TYPE) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                float[] v = (float[])value;
                return new ComplexFloatLargeArray(length, v, true);
            }
            case COMPLEX_DOUBLE: {
                Class<?> dataClass = value.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass != Double.TYPE) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                double[] v = (double[])value;
                return new ComplexDoubleLargeArray(length, v, true);
            }
            case STRING: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                String v = (String)value;
                return new StringLargeArray(length, 100, v, true);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, 1024, value, true);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray create(LargeArrayType type, long length) {
        return LargeArrayUtils.create(type, length, true);
    }

    public static LargeArray create(LargeArrayType type, long length, boolean zeroNativeMemory) {
        switch (type) {
            case LOGIC: {
                return new LogicLargeArray(length, zeroNativeMemory);
            }
            case BYTE: {
                return new ByteLargeArray(length, zeroNativeMemory);
            }
            case UNSIGNED_BYTE: {
                return new UnsignedByteLargeArray(length, zeroNativeMemory);
            }
            case SHORT: {
                return new ShortLargeArray(length, zeroNativeMemory);
            }
            case INT: {
                return new IntLargeArray(length, zeroNativeMemory);
            }
            case LONG: {
                return new LongLargeArray(length, zeroNativeMemory);
            }
            case FLOAT: {
                return new FloatLargeArray(length, zeroNativeMemory);
            }
            case DOUBLE: {
                return new DoubleLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_FLOAT: {
                return new ComplexFloatLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_DOUBLE: {
                return new ComplexDoubleLargeArray(length, zeroNativeMemory);
            }
            case STRING: {
                return new StringLargeArray(length, 100, zeroNativeMemory);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, 100, zeroNativeMemory);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray generateRandom(LargeArrayType type, long length) {
        LargeArray res = LargeArrayUtils.create(type, length, false);
        Random rand = new Random();
        switch (type) {
            case LOGIC: {
                for (long i = 0L; i < length; ++i) {
                    res.setBoolean(i, rand.nextBoolean());
                }
                break;
            }
            case BYTE: 
            case UNSIGNED_BYTE: {
                int r;
                long i;
                for (i = 0L; i < length - 4L; i += 4L) {
                    r = rand.nextInt();
                    res.setByte(i, (byte)r);
                    res.setByte(i + 1L, (byte)(r >> 8));
                    res.setByte(i + 2L, (byte)(r >> 16));
                    res.setByte(i + 3L, (byte)(r >> 24));
                }
                r = rand.nextInt();
                while (i < length) {
                    res.setByte(i, (byte)(r >> (int)((length - 1L - i) * 8L)));
                    ++i;
                }
                break;
            }
            case SHORT: {
                int r;
                long i;
                for (i = 0L; i < length - 2L; i += 2L) {
                    r = rand.nextInt();
                    res.setShort(i, (short)r);
                    res.setShort(i + 1L, (short)(r >> 16));
                }
                r = rand.nextInt();
                while (i < length) {
                    res.setShort(i, (short)(r >> (int)((length - 1L - i) * 16L)));
                    ++i;
                }
                break;
            }
            case INT: {
                for (long i = 0L; i < length; ++i) {
                    res.setInt(i, rand.nextInt());
                }
                break;
            }
            case LONG: {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, rand.nextLong());
                }
                break;
            }
            case FLOAT: {
                for (long i = 0L; i < length; ++i) {
                    res.setFloat(i, rand.nextFloat());
                }
                break;
            }
            case DOUBLE: {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, rand.nextDouble());
                }
                break;
            }
            case COMPLEX_FLOAT: {
                ComplexFloatLargeArray res_c = (ComplexFloatLargeArray)res;
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    elem_res[0] = rand.nextFloat();
                    elem_res[1] = rand.nextFloat();
                    res_c.setComplexFloat(i, elem_res);
                }
                break;
            }
            case COMPLEX_DOUBLE: {
                ComplexDoubleLargeArray res_c = (ComplexDoubleLargeArray)res;
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    elem_res[0] = rand.nextDouble();
                    elem_res[1] = rand.nextDouble();
                    res_c.setComplexDouble(i, elem_res);
                }
                break;
            }
            case STRING: {
                for (long i = 0L; i < length; ++i) {
                    res.setFloat(i, rand.nextFloat());
                }
                break;
            }
            case OBJECT: {
                for (long i = 0L; i < length; ++i) {
                    res.set(i, Float.valueOf(rand.nextFloat()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
        return res;
    }

    public static LargeArray convert(final LargeArray src, final LargeArrayType type) {
        LargeArray out;
        block77: {
            int nthreads;
            long length;
            block76: {
                if (src.getType() == type) {
                    return src;
                }
                if (src.isConstant()) {
                    switch (type) {
                        case LOGIC: 
                        case BYTE: 
                        case UNSIGNED_BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: 
                        case OBJECT: {
                            return LargeArrayUtils.createConstant(type, src.length(), src.get(0L));
                        }
                        case COMPLEX_FLOAT: {
                            if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                                return new ComplexFloatLargeArray(src.length(), ((ComplexDoubleLargeArray)src).getComplexFloat(0L), true);
                            }
                            return new ComplexFloatLargeArray(src.length(), new float[]{src.getFloat(0L), 0.0f}, true);
                        }
                        case COMPLEX_DOUBLE: {
                            if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                                return new ComplexDoubleLargeArray(src.length(), ((ComplexFloatLargeArray)src).getComplexDouble(0L), true);
                            }
                            return new ComplexDoubleLargeArray(src.length(), new double[]{src.getDouble(0L), 0.0}, true);
                        }
                    }
                    throw new IllegalArgumentException("Invalid array type.");
                }
                length = src.length;
                out = LargeArrayUtils.create(type, length, false);
                nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
                if (nthreads >= 2 && length >= ConcurrencyUtils.getConcurrentThreshold()) break block76;
                switch (type) {
                    case LOGIC: {
                        for (long i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i) != 0 ? (byte)1 : 0);
                        }
                        break block77;
                    }
                    case BYTE: {
                        for (long i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i));
                        }
                        break block77;
                    }
                    case UNSIGNED_BYTE: {
                        for (long i = 0L; i < length; ++i) {
                            out.setUnsignedByte(i, src.getUnsignedByte(i));
                        }
                        break block77;
                    }
                    case SHORT: {
                        for (long i = 0L; i < length; ++i) {
                            out.setShort(i, src.getShort(i));
                        }
                        break block77;
                    }
                    case INT: {
                        for (long i = 0L; i < length; ++i) {
                            out.setInt(i, src.getInt(i));
                        }
                        break block77;
                    }
                    case LONG: {
                        for (long i = 0L; i < length; ++i) {
                            out.setLong(i, src.getLong(i));
                        }
                        break block77;
                    }
                    case FLOAT: {
                        for (long i = 0L; i < length; ++i) {
                            out.setFloat(i, src.getFloat(i));
                        }
                        break block77;
                    }
                    case DOUBLE: {
                        for (long i = 0L; i < length; ++i) {
                            out.setDouble(i, src.getDouble(i));
                        }
                        break block77;
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (long i = 0L; i < length; ++i) {
                                ((ComplexFloatLargeArray)out).setComplexFloat(i, ((ComplexDoubleLargeArray)src).getComplexFloat(i));
                            }
                        } else {
                            for (long i = 0L; i < length; ++i) {
                                out.setFloat(i, src.getFloat(i));
                            }
                        }
                        break block77;
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (long i = 0L; i < length; ++i) {
                                ((ComplexDoubleLargeArray)out).setComplexDouble(i, ((ComplexFloatLargeArray)src).getComplexDouble(i));
                            }
                        } else {
                            for (long i = 0L; i < length; ++i) {
                                out.setDouble(i, src.getDouble(i));
                            }
                        }
                        break block77;
                    }
                    case STRING: {
                        for (long i = 0L; i < length; ++i) {
                            out.set(i, src.get(i).toString());
                        }
                        break block77;
                    }
                    case OBJECT: {
                        for (long i = 0L; i < length; ++i) {
                            out.set(i, src.get(i));
                        }
                        break block77;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        switch (type) {
                            case LOGIC: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setByte(i, src.getByte(i) != 0 ? (byte)1 : 0);
                                }
                                break;
                            }
                            case BYTE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setByte(i, src.getByte(i));
                                }
                                break;
                            }
                            case UNSIGNED_BYTE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setUnsignedByte(i, src.getUnsignedByte(i));
                                }
                                break;
                            }
                            case SHORT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setShort(i, src.getShort(i));
                                }
                                break;
                            }
                            case INT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setInt(i, src.getInt(i));
                                }
                                break;
                            }
                            case LONG: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setLong(i, src.getLong(i));
                                }
                                break;
                            }
                            case FLOAT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setFloat(i, src.getFloat(i));
                                }
                                break;
                            }
                            case DOUBLE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setDouble(i, src.getDouble(i));
                                }
                                break;
                            }
                            case COMPLEX_FLOAT: {
                                if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        ((ComplexFloatLargeArray)out).setComplexFloat(i, ((ComplexDoubleLargeArray)src).getComplexFloat(i));
                                    }
                                } else {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        out.setFloat(i, src.getFloat(i));
                                    }
                                }
                                break;
                            }
                            case COMPLEX_DOUBLE: {
                                if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        ((ComplexDoubleLargeArray)out).setComplexDouble(i, ((ComplexFloatLargeArray)src).getComplexDouble(i));
                                    }
                                } else {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        out.setDouble(i, src.getDouble(i));
                                    }
                                }
                                break;
                            }
                            case STRING: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.set(i, src.get(i).toString());
                                }
                                break;
                            }
                            case OBJECT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.set(i, src.get(i));
                                }
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid array type.");
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                switch (type) {
                    case LOGIC: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i) != 0 ? (byte)1 : 0);
                        }
                        break;
                    }
                    case BYTE: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i));
                        }
                        break;
                    }
                    case UNSIGNED_BYTE: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setUnsignedByte(i, src.getUnsignedByte(i));
                        }
                        break;
                    }
                    case SHORT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setShort(i, src.getShort(i));
                        }
                        break;
                    }
                    case INT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setInt(i, src.getInt(i));
                        }
                        break;
                    }
                    case LONG: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setLong(i, src.getLong(i));
                        }
                        break;
                    }
                    case FLOAT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setFloat(i, src.getFloat(i));
                        }
                        break;
                    }
                    case DOUBLE: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setDouble(i, src.getDouble(i));
                        }
                        break;
                    }
                    case COMPLEX_FLOAT: {
                        long i;
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexFloatLargeArray)out).setComplexFloat(i, ((ComplexDoubleLargeArray)src).getComplexFloat(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setFloat(i, src.getFloat(i));
                            }
                        }
                        break;
                    }
                    case COMPLEX_DOUBLE: {
                        long i;
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexDoubleLargeArray)out).setComplexDouble(i, ((ComplexFloatLargeArray)src).getComplexDouble(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setDouble(i, src.getDouble(i));
                            }
                        }
                        break;
                    }
                    case STRING: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i).toString());
                        }
                        break;
                    }
                    case OBJECT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
        }
        return out;
    }

    public static LargeArray select(LargeArray src, final LogicLargeArray mask) {
        long j;
        int j2;
        if (src.length != mask.length) {
            throw new IllegalArgumentException("src.length != mask.length");
        }
        long length = src.length;
        long count = 0L;
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        long k = length / (long)nthreads;
        Future[] futures = new Future[nthreads];
        for (j2 = 0; j2 < nthreads; ++j2) {
            final long firstIdx = (long)j2 * k;
            final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
            futures[j2] = ConcurrencyUtils.submit(new Callable(){

                public Long call() {
                    long count = 0L;
                    for (long k = firstIdx; k < lastIdx; ++k) {
                        if (mask.getByte(k) != 1) continue;
                        ++count;
                    }
                    return count;
                }
            });
        }
        try {
            for (j2 = 0; j2 < nthreads; ++j2) {
                count += ((Long)futures[j2].get()).longValue();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            for (j = 0L; j < length; ++j) {
                if (mask.getByte(j) != 1) continue;
                ++count;
            }
        }
        if (count <= 0L) {
            return null;
        }
        LargeArray res = LargeArrayUtils.create(src.getType(), count, false);
        k = 0L;
        for (j = 0L; j < length; ++j) {
            if (mask.getByte(j) != 1) continue;
            res.set(k++, src.get(j));
        }
        return res;
    }

    static {
        Object theUnsafe = null;
        Exception exception = null;
        try {
            Class<?> uc = Class.forName("sun.misc.Unsafe");
            Field f = uc.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = f.get(uc);
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        catch (NoSuchFieldException e) {
            exception = e;
        }
        catch (SecurityException e) {
            exception = e;
        }
        UNSAFE = (Unsafe)theUnsafe;
        if (UNSAFE == null) {
            throw new Error("Could not obtain access to sun.misc.Unsafe", exception);
        }
    }
}

