/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.IntLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayTest;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.LogicLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.ObjectLargeArray;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.StringLargeArray;
import pl.edu.icm.jlargearrays.UnsignedByteLargeArray;

public class LargeArrayUtilTest
extends LargeArrayTest {
    public LargeArrayUtilTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testLogicLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.LOGIC, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        LogicLargeArray b = new LogicLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((Object)false, (Object)b.getBoolean(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)a.getBoolean(srcPos + i2), (Object)b.getBoolean(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((Object)false, (Object)b.getBoolean(i2));
            ++i2;
        }
        b = new LogicLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getByteData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((Object)false, (Object)b.getBoolean(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)a.getBoolean(srcPos + i2), (Object)b.getBoolean(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((Object)false, (Object)b.getBoolean(i2));
            ++i2;
        }
        byte[] bb = new byte[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new LogicLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((Object)false, (Object)b.getBoolean(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((Object)a.getBoolean(srcPos + i), (Object)b.getBoolean(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((Object)false, (Object)b.getBoolean(i));
            ++i;
        }
    }

    @Test
    public void testLogicLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.LOGIC, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.INT);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((long)a.getInt(i), (long)b.getInt(i));
            ++i;
        }
    }

    @Test
    public void testByteLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        ByteLargeArray b = new ByteLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getByte(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getByte(srcPos + i2), (long)b.getByte(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getByte(i2));
            ++i2;
        }
        b = new ByteLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getByteData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getByte(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getByte(srcPos + i2), (long)b.getByte(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getByte(i2));
            ++i2;
        }
        byte[] bb = new byte[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new ByteLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((long)0L, (long)b.getByte(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)a.getByte(srcPos + i), (long)b.getByte(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getByte(i));
            ++i;
        }
    }

    @Test
    public void testByteLargeArraySubarraycopy() {
        byte[] src2 = new byte[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        byte[] dest2 = new byte[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        byte[] expectedDest2 = new byte[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = (byte)(i + 1);
        }
        expectedDest2[17] = 9;
        expectedDest2[18] = 10;
        expectedDest2[19] = 11;
        expectedDest2[24] = 15;
        expectedDest2[25] = 16;
        expectedDest2[26] = 17;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2);
        ByteLargeArray src2Large = new ByteLargeArray(src2);
        ByteLargeArray dest2Large = new ByteLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2);
        byte[] src3 = new byte[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        byte[] dest3 = new byte[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        byte[] expectedDest3 = new byte[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = (byte)(i + 1);
        }
        expectedDest3[109] = 46;
        expectedDest3[110] = 47;
        expectedDest3[116] = 52;
        expectedDest3[117] = 53;
        expectedDest3[123] = 58;
        expectedDest3[124] = 59;
        expectedDest3[151] = 76;
        expectedDest3[152] = 77;
        expectedDest3[158] = 82;
        expectedDest3[159] = 83;
        expectedDest3[165] = 88;
        expectedDest3[166] = 89;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3);
        ByteLargeArray src3Large = new ByteLargeArray(src3);
        ByteLargeArray dest3Large = new ByteLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3);
    }

    @Test
    public void testByteLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.LOGIC);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((long)(a.getInt(i) != 0 ? 1L : 0L), (long)b.getByte(i));
            ++i;
        }
    }

    @Test
    public void testUnsignedByteLargeArrayArraycopy() {
        int i;
        int i2;
        UnsignedByteLargeArray a = (UnsignedByteLargeArray)LargeArrayUtils.generateRandom(LargeArrayType.UNSIGNED_BYTE, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        UnsignedByteLargeArray b = new UnsignedByteLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getUnsignedByte(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getUnsignedByte(srcPos + i2), (long)b.getUnsignedByte(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getUnsignedByte(i2));
            ++i2;
        }
        b = new UnsignedByteLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getUnsignedByteData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getUnsignedByte(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getUnsignedByte(srcPos + i2), (long)b.getUnsignedByte(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getUnsignedByte(i2));
            ++i2;
        }
        byte[] bb = new byte[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new UnsignedByteLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((long)0L, (long)b.getUnsignedByte(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)a.getUnsignedByte(srcPos + i), (long)b.getUnsignedByte(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getUnsignedByte(i));
            ++i;
        }
    }

    @Test
    public void testUnsignedByteLargeArraySubarraycopy() {
        byte[] src2 = new byte[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        byte[] dest2 = new byte[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        byte[] expectedDest2 = new byte[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = (byte)(i + 1);
        }
        expectedDest2[17] = 9;
        expectedDest2[18] = 10;
        expectedDest2[19] = 11;
        expectedDest2[24] = 15;
        expectedDest2[25] = 16;
        expectedDest2[26] = 17;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2);
        UnsignedByteLargeArray src2Large = new UnsignedByteLargeArray(src2);
        UnsignedByteLargeArray dest2Large = new UnsignedByteLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((byte[])expectedDest2, (byte[])dest2);
        byte[] src3 = new byte[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        byte[] dest3 = new byte[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        byte[] expectedDest3 = new byte[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = (byte)(i + 1);
        }
        expectedDest3[109] = 46;
        expectedDest3[110] = 47;
        expectedDest3[116] = 52;
        expectedDest3[117] = 53;
        expectedDest3[123] = 58;
        expectedDest3[124] = 59;
        expectedDest3[151] = 76;
        expectedDest3[152] = 77;
        expectedDest3[158] = 82;
        expectedDest3[159] = 83;
        expectedDest3[165] = 88;
        expectedDest3[166] = 89;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3);
        UnsignedByteLargeArray src3Large = new UnsignedByteLargeArray(src3);
        UnsignedByteLargeArray dest3Large = new UnsignedByteLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3Large.getByteData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((byte[])expectedDest3, (byte[])dest3);
    }

    @Test
    public void testUnsignedByteLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.UNSIGNED_BYTE, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.INT);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((long)a.getInt(i), (long)b.getInt(i));
            ++i;
        }
    }

    @Test
    public void testShortLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.SHORT, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        ShortLargeArray b = new ShortLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getShort(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getShort(srcPos + i2), (long)b.getShort(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getShort(i2));
            ++i2;
        }
        b = new ShortLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getShortData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getShort(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getShort(srcPos + i2), (long)b.getShort(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getShort(i2));
            ++i2;
        }
        short[] bb = new short[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new ShortLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((long)0L, (long)b.getShort(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)a.getShort(srcPos + i), (long)b.getShort(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getShort(i));
            ++i;
        }
    }

    @Test
    public void testShortLargeArraySubarraycopy() {
        short[] src2 = new short[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        short[] dest2 = new short[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        short[] expectedDest2 = new short[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = (short)(i + 1);
        }
        expectedDest2[17] = 9;
        expectedDest2[18] = 10;
        expectedDest2[19] = 11;
        expectedDest2[24] = 15;
        expectedDest2[25] = 16;
        expectedDest2[26] = 17;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((short[])expectedDest2, (short[])dest2);
        ShortLargeArray src2Large = new ShortLargeArray(src2);
        ShortLargeArray dest2Large = new ShortLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((short[])expectedDest2, (short[])dest2Large.getShortData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((short[])expectedDest2, (short[])dest2Large.getShortData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((short[])expectedDest2, (short[])dest2);
        short[] src3 = new short[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        short[] dest3 = new short[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        short[] expectedDest3 = new short[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = (short)(i + 1);
        }
        expectedDest3[109] = 46;
        expectedDest3[110] = 47;
        expectedDest3[116] = 52;
        expectedDest3[117] = 53;
        expectedDest3[123] = 58;
        expectedDest3[124] = 59;
        expectedDest3[151] = 76;
        expectedDest3[152] = 77;
        expectedDest3[158] = 82;
        expectedDest3[159] = 83;
        expectedDest3[165] = 88;
        expectedDest3[166] = 89;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((short[])expectedDest3, (short[])dest3);
        ShortLargeArray src3Large = new ShortLargeArray(src3);
        ShortLargeArray dest3Large = new ShortLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((short[])expectedDest3, (short[])dest3Large.getShortData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((short[])expectedDest3, (short[])dest3Large.getShortData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((short[])expectedDest3, (short[])dest3);
    }

    @Test
    public void testShortLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.SHORT, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.INT);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((long)a.getInt(i), (long)b.getInt(i));
            ++i;
        }
    }

    @Test
    public void testIntLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.INT, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        IntLargeArray b = new IntLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getInt(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getInt(srcPos + i2), (long)b.getInt(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getInt(i2));
            ++i2;
        }
        b = new IntLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getIntData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getInt(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getInt(srcPos + i2), (long)b.getInt(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getInt(i2));
            ++i2;
        }
        int[] bb = new int[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new IntLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((long)0L, (long)b.getInt(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)a.getInt(srcPos + i), (long)b.getInt(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getInt(i));
            ++i;
        }
    }

    @Test
    public void testIntLargeArraySubarraycopy() {
        int[] src2 = new int[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        int[] dest2 = new int[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        int[] expectedDest2 = new int[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = i + 1;
        }
        expectedDest2[17] = 9;
        expectedDest2[18] = 10;
        expectedDest2[19] = 11;
        expectedDest2[24] = 15;
        expectedDest2[25] = 16;
        expectedDest2[26] = 17;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((int[])expectedDest2, (int[])dest2);
        IntLargeArray src2Large = new IntLargeArray(src2);
        IntLargeArray dest2Large = new IntLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((int[])expectedDest2, (int[])dest2Large.getIntData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((int[])expectedDest2, (int[])dest2Large.getIntData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((int[])expectedDest2, (int[])dest2);
        int[] src3 = new int[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        int[] dest3 = new int[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        int[] expectedDest3 = new int[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = i + 1;
        }
        expectedDest3[109] = 46;
        expectedDest3[110] = 47;
        expectedDest3[116] = 52;
        expectedDest3[117] = 53;
        expectedDest3[123] = 58;
        expectedDest3[124] = 59;
        expectedDest3[151] = 76;
        expectedDest3[152] = 77;
        expectedDest3[158] = 82;
        expectedDest3[159] = 83;
        expectedDest3[165] = 88;
        expectedDest3[166] = 89;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((int[])expectedDest3, (int[])dest3);
        IntLargeArray src3Large = new IntLargeArray(src3);
        IntLargeArray dest3Large = new IntLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((int[])expectedDest3, (int[])dest3Large.getIntData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((int[])expectedDest3, (int[])dest3Large.getIntData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((int[])expectedDest3, (int[])dest3);
    }

    @Test
    public void testIntLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.INT, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.LONG);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((long)a.getLong(i), (long)b.getLong(i));
            ++i;
        }
    }

    @Test
    public void testLongLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.LONG, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        LongLargeArray b = new LongLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getLong(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getLong(srcPos + i2), (long)b.getLong(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getLong(i2));
            ++i2;
        }
        b = new LongLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getLongData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((long)0L, (long)b.getLong(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((long)a.getLong(srcPos + i2), (long)b.getLong(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getLong(i2));
            ++i2;
        }
        long[] bb = new long[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new LongLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((long)0L, (long)b.getLong(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)a.getLong(srcPos + i), (long)b.getLong(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((long)0L, (long)b.getLong(i));
            ++i;
        }
    }

    @Test
    public void testLongLargeArraySubarraycopy() {
        long[] src2 = new long[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        long[] dest2 = new long[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        long[] expectedDest2 = new long[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = i + 1;
        }
        expectedDest2[17] = 9L;
        expectedDest2[18] = 10L;
        expectedDest2[19] = 11L;
        expectedDest2[24] = 15L;
        expectedDest2[25] = 16L;
        expectedDest2[26] = 17L;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((long[])expectedDest2, (long[])dest2);
        LongLargeArray src2Large = new LongLargeArray(src2);
        LongLargeArray dest2Large = new LongLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((long[])expectedDest2, (long[])dest2Large.getLongData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((long[])expectedDest2, (long[])dest2Large.getLongData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((long[])expectedDest2, (long[])dest2);
        long[] src3 = new long[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        long[] dest3 = new long[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        long[] expectedDest3 = new long[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = i + 1;
        }
        expectedDest3[109] = 46L;
        expectedDest3[110] = 47L;
        expectedDest3[116] = 52L;
        expectedDest3[117] = 53L;
        expectedDest3[123] = 58L;
        expectedDest3[124] = 59L;
        expectedDest3[151] = 76L;
        expectedDest3[152] = 77L;
        expectedDest3[158] = 82L;
        expectedDest3[159] = 83L;
        expectedDest3[165] = 88L;
        expectedDest3[166] = 89L;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((long[])expectedDest3, (long[])dest3);
        LongLargeArray src3Large = new LongLargeArray(src3);
        LongLargeArray dest3Large = new LongLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((long[])expectedDest3, (long[])dest3Large.getLongData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((long[])expectedDest3, (long[])dest3Large.getLongData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((long[])expectedDest3, (long[])dest3);
    }

    @Test
    public void testLongLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.LONG, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.FLOAT);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((double)a.getFloat(i), (double)b.getFloat(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testFloatlargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        FloatLargeArray b = new FloatLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((double)0.0, (double)b.getFloat(i2), (double)1.0E-6);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((double)a.getFloat(srcPos + i2), (double)b.getFloat(destPos + i2), (double)1.0E-6);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((double)0.0, (double)b.getFloat(i2), (double)1.0E-6);
            ++i2;
        }
        b = new FloatLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getFloatData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((double)0.0, (double)b.getFloat(i2), (double)1.0E-6);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((double)a.getFloat(srcPos + i2), (double)b.getFloat(destPos + i2), (double)1.0E-6);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((double)0.0, (double)b.getFloat(i2), (double)1.0E-6);
            ++i2;
        }
        float[] bb = new float[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new FloatLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((double)0.0, (double)b.getFloat(i), (double)1.0E-6);
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((double)a.getFloat(srcPos + i), (double)b.getFloat(destPos + i), (double)1.0E-6);
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((double)0.0, (double)b.getFloat(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testFloatLargeArraySubarraycopy() {
        float[] src2 = new float[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        float[] dest2 = new float[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        float[] expectedDest2 = new float[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = i + 1;
        }
        expectedDest2[17] = 9.0f;
        expectedDest2[18] = 10.0f;
        expectedDest2[19] = 11.0f;
        expectedDest2[24] = 15.0f;
        expectedDest2[25] = 16.0f;
        expectedDest2[26] = 17.0f;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((float[])expectedDest2, (float[])dest2, (float)1.0E-6f);
        FloatLargeArray src2Large = new FloatLargeArray(src2);
        FloatLargeArray dest2Large = new FloatLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((float[])expectedDest2, (float[])dest2Large.getFloatData(), (float)1.0E-6f);
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((float[])expectedDest2, (float[])dest2Large.getFloatData(), (float)1.0E-6f);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((float[])expectedDest2, (float[])dest2, (float)1.0E-6f);
        float[] src3 = new float[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        float[] dest3 = new float[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        float[] expectedDest3 = new float[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = i + 1;
        }
        expectedDest3[109] = 46.0f;
        expectedDest3[110] = 47.0f;
        expectedDest3[116] = 52.0f;
        expectedDest3[117] = 53.0f;
        expectedDest3[123] = 58.0f;
        expectedDest3[124] = 59.0f;
        expectedDest3[151] = 76.0f;
        expectedDest3[152] = 77.0f;
        expectedDest3[158] = 82.0f;
        expectedDest3[159] = 83.0f;
        expectedDest3[165] = 88.0f;
        expectedDest3[166] = 89.0f;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((float[])expectedDest3, (float[])dest3, (float)1.0E-6f);
        FloatLargeArray src3Large = new FloatLargeArray(src3);
        FloatLargeArray dest3Large = new FloatLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((float[])expectedDest3, (float[])dest3Large.getFloatData(), (float)1.0E-6f);
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((float[])expectedDest3, (float[])dest3Large.getFloatData(), (float)1.0E-6f);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((float[])expectedDest3, (float[])dest3, (float)1.0E-6f);
    }

    @Test
    public void testFloatLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.DOUBLE);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((double)a.getDouble(i), (double)b.getDouble(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testDoubleLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        DoubleLargeArray b = new DoubleLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((double)0.0, (double)b.getDouble(i2), (double)1.0E-6);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((double)a.getDouble(srcPos + i2), (double)b.getDouble(destPos + i2), (double)1.0E-6);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((double)0.0, (double)b.getDouble(i2), (double)1.0E-6);
            ++i2;
        }
        b = new DoubleLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getDoubleData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals((double)0.0, (double)b.getDouble(i2), (double)1.0E-6);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((double)a.getDouble(srcPos + i2), (double)b.getDouble(destPos + i2), (double)1.0E-6);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals((double)0.0, (double)b.getDouble(i2), (double)1.0E-6);
            ++i2;
        }
        double[] bb = new double[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new DoubleLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((double)0.0, (double)b.getDouble(i), (double)1.0E-6);
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((double)a.getDouble(srcPos + i), (double)b.getDouble(destPos + i), (double)1.0E-6);
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((double)0.0, (double)b.getDouble(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testDoubleLargeArraySubarraycopy() {
        double[] src2 = new double[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        double[] dest2 = new double[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        double[] expectedDest2 = new double[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = i + 1;
        }
        expectedDest2[17] = 9.0;
        expectedDest2[18] = 10.0;
        expectedDest2[19] = 11.0;
        expectedDest2[24] = 15.0;
        expectedDest2[25] = 16.0;
        expectedDest2[26] = 17.0;
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((double[])expectedDest2, (double[])dest2, (double)1.0E-6);
        DoubleLargeArray src2Large = new DoubleLargeArray(src2);
        DoubleLargeArray dest2Large = new DoubleLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((double[])expectedDest2, (double[])dest2Large.getDoubleData(), (double)1.0E-6);
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((double[])expectedDest2, (double[])dest2Large.getDoubleData(), (double)1.0E-6);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((double[])expectedDest2, (double[])dest2, (double)1.0E-6);
        double[] src3 = new double[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        double[] dest3 = new double[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        double[] expectedDest3 = new double[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = i + 1;
        }
        expectedDest3[109] = 46.0;
        expectedDest3[110] = 47.0;
        expectedDest3[116] = 52.0;
        expectedDest3[117] = 53.0;
        expectedDest3[123] = 58.0;
        expectedDest3[124] = 59.0;
        expectedDest3[151] = 76.0;
        expectedDest3[152] = 77.0;
        expectedDest3[158] = 82.0;
        expectedDest3[159] = 83.0;
        expectedDest3[165] = 88.0;
        expectedDest3[166] = 89.0;
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((double[])expectedDest3, (double[])dest3, (double)1.0E-6);
        DoubleLargeArray src3Large = new DoubleLargeArray(src3);
        DoubleLargeArray dest3Large = new DoubleLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((double[])expectedDest3, (double[])dest3Large.getDoubleData(), (double)1.0E-6);
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((double[])expectedDest3, (double[])dest3Large.getDoubleData(), (double)1.0E-6);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((double[])expectedDest3, (double[])dest3, (double)1.0E-6);
    }

    @Test
    public void testDoubleLargeArrayConvert() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.FLOAT);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((double)a.getDouble(i), (double)b.getDouble(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testComplexFloatLargeArrayArraycopy() {
        int i;
        int i2;
        ComplexFloatLargeArray a = (ComplexFloatLargeArray)LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        int srcPos = 2;
        int destPos = 4;
        int length = (int)a.length() - 2;
        ComplexFloatLargeArray b = new ComplexFloatLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f}, (float[])b.getComplexFloat(i2), (float)1.0E-6f);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertArrayEquals((float[])a.getComplexFloat(srcPos + i2), (float[])b.getComplexFloat(destPos + i2), (float)1.0E-6f);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f}, (float[])b.getComplexFloat(i2), (float)1.0E-6f);
            ++i2;
        }
        b = new ComplexFloatLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getComplexData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f}, (float[])b.getComplexFloat(i2), (float)1.0E-6f);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertArrayEquals((float[])a.getComplexFloat(srcPos / 2 + i2), (float[])b.getComplexFloat(destPos + i2), (float)1.0E-6f);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f}, (float[])b.getComplexFloat(i2), (float)1.0E-6f);
            ++i2;
        }
        float[] bb = new float[4 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new ComplexFloatLargeArray(bb);
        for (i = 0; i < destPos / 2; ++i) {
            Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f}, (float[])b.getComplexFloat(i), (float)1.0E-6f);
        }
        for (i = 0; i < length; ++i) {
            Assert.assertArrayEquals((float[])a.getComplexFloat(srcPos + i), (float[])b.getComplexFloat(destPos / 2 + i), (float)1.0E-6f);
        }
        i = destPos / 2 + length;
        while ((long)i < b.length()) {
            Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f}, (float[])b.getComplexFloat(i), (float)1.0E-6f);
            ++i;
        }
    }

    @Test
    public void testComplexFloatLargeArraySubarraycopy() {
        float[] src2 = new float[48];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        float[] dest2 = new float[70];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        float[] expectedDest2 = new float[70];
        for (int i = 0; i < 24; ++i) {
            src2[2 * i] = i + 1;
        }
        expectedDest2[34] = 9.0f;
        expectedDest2[36] = 10.0f;
        expectedDest2[38] = 11.0f;
        expectedDest2[48] = 15.0f;
        expectedDest2[50] = 16.0f;
        expectedDest2[52] = 17.0f;
        ComplexFloatLargeArray src2Large = new ComplexFloatLargeArray(src2);
        ComplexFloatLargeArray dest2Large = new ComplexFloatLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((float[])expectedDest2, (float[])dest2Large.getComplexData(), (float)1.0E-6f);
        float[] src3 = new float[240];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        float[] dest3 = new float[420];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        float[] expectedDest3 = new float[420];
        for (int i = 0; i < 120; ++i) {
            src3[2 * i] = i + 1;
        }
        expectedDest3[218] = 46.0f;
        expectedDest3[220] = 47.0f;
        expectedDest3[232] = 52.0f;
        expectedDest3[234] = 53.0f;
        expectedDest3[246] = 58.0f;
        expectedDest3[248] = 59.0f;
        expectedDest3[302] = 76.0f;
        expectedDest3[304] = 77.0f;
        expectedDest3[316] = 82.0f;
        expectedDest3[318] = 83.0f;
        expectedDest3[330] = 88.0f;
        expectedDest3[332] = 89.0f;
        ComplexFloatLargeArray src3Large = new ComplexFloatLargeArray(src3);
        ComplexFloatLargeArray dest3Large = new ComplexFloatLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((float[])expectedDest3, (float[])dest3Large.getComplexData(), (float)1.0E-6f);
    }

    @Test
    public void testComplexFloatLargeArrayConvert() {
        ComplexFloatLargeArray a = (ComplexFloatLargeArray)LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.DOUBLE);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((double)a.getComplexDouble(i)[0], (double)b.getDouble(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testComplexDoubleLargeArrayArraycopy() {
        int i;
        int i2;
        ComplexDoubleLargeArray a = (ComplexDoubleLargeArray)LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_DOUBLE, 10L);
        int srcPos = 2;
        int destPos = 4;
        int length = (int)a.length() - 2;
        ComplexDoubleLargeArray b = new ComplexDoubleLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])b.getComplexDouble(i2), (double)1.0E-6);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertArrayEquals((double[])a.getComplexDouble(srcPos + i2), (double[])b.getComplexDouble(destPos + i2), (double)1.0E-6);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])b.getComplexDouble(i2), (double)1.0E-6);
            ++i2;
        }
        b = new ComplexDoubleLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a.getComplexData(), (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])b.getComplexDouble(i2), (double)1.0E-6);
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertArrayEquals((double[])a.getComplexDouble(srcPos / 2 + i2), (double[])b.getComplexDouble(destPos + i2), (double)1.0E-6);
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])b.getComplexDouble(i2), (double)1.0E-6);
            ++i2;
        }
        double[] bb = new double[4 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new ComplexDoubleLargeArray(bb);
        for (i = 0; i < destPos / 2; ++i) {
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])b.getComplexDouble(i), (double)1.0E-6);
        }
        for (i = 0; i < length; ++i) {
            Assert.assertArrayEquals((double[])a.getComplexDouble(srcPos + i), (double[])b.getComplexDouble(destPos / 2 + i), (double)1.0E-6);
        }
        i = destPos / 2 + length;
        while ((long)i < b.length()) {
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])b.getComplexDouble(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testComplexDoubleLargeArraySubarraycopy() {
        double[] src2 = new double[48];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        double[] dest2 = new double[70];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        double[] expectedDest2 = new double[70];
        for (int i = 0; i < 24; ++i) {
            src2[2 * i] = i + 1;
        }
        expectedDest2[34] = 9.0;
        expectedDest2[36] = 10.0;
        expectedDest2[38] = 11.0;
        expectedDest2[48] = 15.0;
        expectedDest2[50] = 16.0;
        expectedDest2[52] = 17.0;
        ComplexDoubleLargeArray src2Large = new ComplexDoubleLargeArray(src2);
        ComplexDoubleLargeArray dest2Large = new ComplexDoubleLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((double[])expectedDest2, (double[])dest2Large.getComplexData(), (double)1.0E-6);
        double[] src3 = new double[240];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        double[] dest3 = new double[420];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        double[] expectedDest3 = new double[420];
        for (int i = 0; i < 120; ++i) {
            src3[2 * i] = i + 1;
        }
        expectedDest3[218] = 46.0;
        expectedDest3[220] = 47.0;
        expectedDest3[232] = 52.0;
        expectedDest3[234] = 53.0;
        expectedDest3[246] = 58.0;
        expectedDest3[248] = 59.0;
        expectedDest3[302] = 76.0;
        expectedDest3[304] = 77.0;
        expectedDest3[316] = 82.0;
        expectedDest3[318] = 83.0;
        expectedDest3[330] = 88.0;
        expectedDest3[332] = 89.0;
        ComplexDoubleLargeArray src3Large = new ComplexDoubleLargeArray(src3);
        ComplexDoubleLargeArray dest3Large = new ComplexDoubleLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((double[])expectedDest3, (double[])dest3Large.getComplexData(), (double)1.0E-6);
    }

    @Test
    public void testComplexDoubleLargeArrayConvert() {
        ComplexDoubleLargeArray a = (ComplexDoubleLargeArray)LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_DOUBLE, 10L);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.DOUBLE);
        int i = 0;
        while ((long)i < a.length()) {
            Assert.assertEquals((double)a.getComplexDouble(i)[0], (double)b.getDouble(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void testStringLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.STRING, 10L);
        String[] data = new String[(int)a.length()];
        for (int i3 = 0; i3 < data.length; ++i3) {
            data[i3] = (String)a.get(i3);
        }
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        StringLargeArray b = new StringLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals(null, (Object)b.get(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)a.get(srcPos + i2), (Object)b.get(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals(null, (Object)b.get(i2));
            ++i2;
        }
        b = new StringLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)data, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals(null, (Object)b.get(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)a.get(srcPos + i2), (Object)b.get(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals(null, (Object)b.get(i2));
            ++i2;
        }
        String[] bb = new String[2 * length];
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new StringLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals(null, (Object)b.get(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((Object)a.get(srcPos + i), (Object)b.get(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals(null, (Object)b.get(i));
            ++i;
        }
    }

    @Test
    public void testStringLargeArraySubarraycopy() {
        String[] src2 = new String[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        Object[] dest2 = new String[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        Object[] expectedDest2 = new String[35];
        for (int i = 0; i < 24; ++i) {
            src2[i] = Integer.toString(i + 1);
        }
        expectedDest2[17] = Integer.toString(9);
        expectedDest2[18] = Integer.toString(10);
        expectedDest2[19] = Integer.toString(11);
        expectedDest2[24] = Integer.toString(15);
        expectedDest2[25] = Integer.toString(16);
        expectedDest2[26] = Integer.toString(17);
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2);
        StringLargeArray src2Large = new StringLargeArray(src2);
        StringLargeArray dest2Large = new StringLargeArray((String[])dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2Large.getData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2Large.getData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2);
        String[] src3 = new String[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        Object[] dest3 = new String[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        Object[] expectedDest3 = new String[210];
        for (int i = 0; i < 120; ++i) {
            src3[i] = Integer.toString(i + 1);
        }
        expectedDest3[109] = Integer.toString(46);
        expectedDest3[110] = Integer.toString(47);
        expectedDest3[116] = Integer.toString(52);
        expectedDest3[117] = Integer.toString(53);
        expectedDest3[123] = Integer.toString(58);
        expectedDest3[124] = Integer.toString(59);
        expectedDest3[151] = Integer.toString(76);
        expectedDest3[152] = Integer.toString(77);
        expectedDest3[158] = Integer.toString(82);
        expectedDest3[159] = Integer.toString(83);
        expectedDest3[165] = Integer.toString(88);
        expectedDest3[166] = Integer.toString(89);
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3);
        StringLargeArray src3Large = new StringLargeArray(src3);
        StringLargeArray dest3Large = new StringLargeArray((String[])dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3Large.getData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3Large.getData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3);
    }

    @Test
    public void testStringLargeArrayConvert() {
        String[] data = new String[]{"a", "ab", "abc", "\u0105\u0119\u0107", "1234", "test string", "ANOTHER TEST STRING", "", "\n", "\r"};
        StringLargeArray a = new StringLargeArray(data);
        IntLargeArray b = (IntLargeArray)LargeArrayUtils.convert(a, LargeArrayType.INT);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)data[i].length(), (long)b.getInt(i));
        }
    }

    @Test
    public void testObjectLargeArrayArraycopy() {
        int i;
        int i2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.OBJECT, 10L);
        Object[] data = new Object[(int)a.length()];
        for (int i3 = 0; i3 < data.length; ++i3) {
            data[i3] = a.get(i3);
        }
        int srcPos = 2;
        int destPos = 3;
        int length = (int)a.length() - 2;
        ObjectLargeArray b = new ObjectLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals(null, (Object)b.get(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)a.get(srcPos + i2), (Object)b.get(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals(null, (Object)b.get(i2));
            ++i2;
        }
        b = new ObjectLargeArray(2 * length);
        LargeArrayUtils.arraycopy((Object)data, (long)srcPos, (Object)b, (long)destPos, (long)length);
        for (i2 = 0; i2 < destPos; ++i2) {
            Assert.assertEquals(null, (Object)b.get(i2));
        }
        for (i2 = 0; i2 < length; ++i2) {
            Assert.assertEquals((Object)a.get(srcPos + i2), (Object)b.get(destPos + i2));
        }
        i2 = destPos + length;
        while ((long)i2 < b.length()) {
            Assert.assertEquals(null, (Object)b.get(i2));
            ++i2;
        }
        Object[] bb = new Object[2 * length];
        for (i = 0; i < bb.length; ++i) {
            bb[i] = new Float(0.0f);
        }
        LargeArrayUtils.arraycopy((Object)a, (long)srcPos, (Object)bb, (long)destPos, (long)length);
        b = new ObjectLargeArray(bb);
        for (i = 0; i < destPos; ++i) {
            Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)b.get(i));
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((Object)a.get(srcPos + i), (Object)b.get(destPos + i));
        }
        i = destPos + length;
        while ((long)i < b.length()) {
            Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)b.get(i));
            ++i;
        }
    }

    @Test
    public void testObjectLargeArraySubarraycopy() {
        int i;
        int i2;
        Object[] src2 = new Object[24];
        long[] srcDim2 = new long[]{6L, 4L};
        long[] srcPos2 = new long[]{2L, 1L};
        Object[] dest2 = new Object[35];
        long[] destDim2 = new long[]{7L, 5L};
        long[] destPos2 = new long[]{3L, 2L};
        long[] size2 = new long[]{3L, 2L};
        Object[] expectedDest2 = new Object[35];
        for (i2 = 0; i2 < 24; ++i2) {
            src2[i2] = Integer.toString(i2 + 1);
        }
        for (i2 = 0; i2 < 35; ++i2) {
            dest2[i2] = Integer.toString(0);
            expectedDest2[i2] = Integer.toString(0);
        }
        expectedDest2[17] = Integer.toString(9);
        expectedDest2[18] = Integer.toString(10);
        expectedDest2[19] = Integer.toString(11);
        expectedDest2[24] = Integer.toString(15);
        expectedDest2[25] = Integer.toString(16);
        expectedDest2[26] = Integer.toString(17);
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2);
        ObjectLargeArray src2Large = new ObjectLargeArray(src2);
        ObjectLargeArray dest2Large = new ObjectLargeArray(dest2);
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2Large.getData());
        LargeArrayUtils.subarraycopy((Object)src2, srcDim2, srcPos2, (Object)dest2Large, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2Large.getData());
        LargeArrayUtils.subarraycopy((Object)src2Large, srcDim2, srcPos2, (Object)dest2, destDim2, destPos2, size2);
        Assert.assertArrayEquals((Object[])expectedDest2, (Object[])dest2);
        Object[] src3 = new Object[120];
        long[] srcDim3 = new long[]{6L, 5L, 4L};
        long[] srcPos3 = new long[]{3L, 2L, 1L};
        Object[] dest3 = new Object[210];
        long[] destDim3 = new long[]{7L, 6L, 5L};
        long[] destPos3 = new long[]{4L, 3L, 2L};
        long[] size3 = new long[]{2L, 3L, 2L};
        Object[] expectedDest3 = new Object[210];
        for (i = 0; i < 120; ++i) {
            src3[i] = Integer.toString(i + 1);
        }
        for (i = 0; i < 210; ++i) {
            dest3[i] = Integer.toString(0);
            expectedDest3[i] = Integer.toString(0);
        }
        expectedDest3[109] = Integer.toString(46);
        expectedDest3[110] = Integer.toString(47);
        expectedDest3[116] = Integer.toString(52);
        expectedDest3[117] = Integer.toString(53);
        expectedDest3[123] = Integer.toString(58);
        expectedDest3[124] = Integer.toString(59);
        expectedDest3[151] = Integer.toString(76);
        expectedDest3[152] = Integer.toString(77);
        expectedDest3[158] = Integer.toString(82);
        expectedDest3[159] = Integer.toString(83);
        expectedDest3[165] = Integer.toString(88);
        expectedDest3[166] = Integer.toString(89);
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3);
        ObjectLargeArray src3Large = new ObjectLargeArray(src3);
        ObjectLargeArray dest3Large = new ObjectLargeArray(dest3);
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3Large.getData());
        LargeArrayUtils.subarraycopy((Object)src3, srcDim3, srcPos3, (Object)dest3Large, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3Large.getData());
        LargeArrayUtils.subarraycopy((Object)src3Large, srcDim3, srcPos3, (Object)dest3, destDim3, destPos3, size3);
        Assert.assertArrayEquals((Object[])expectedDest3, (Object[])dest3);
    }

    @Test
    public void testObjectLargeArrayConvert() {
        Object[] data = new Object[]{1.12345, -1.54321, 100.0, -100.0, Double.MAX_VALUE, Double.MIN_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN, Double.MIN_NORMAL};
        ObjectLargeArray a = new ObjectLargeArray(data);
        LargeArray b = LargeArrayUtils.convert(a, LargeArrayType.STRING);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((Object)data[i].toString(), (Object)b.get(i));
        }
    }

    @Test
    public void testSelect() {
        double[] d = new double[]{1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9, 10.1};
        byte[] m = new byte[]{0, 0, 1, 0, 1, 1, 1, 0, 0, 0};
        int length = 4;
        DoubleLargeArray data = new DoubleLargeArray(d);
        LogicLargeArray mask = new LogicLargeArray(m);
        LargeArray res = LargeArrayUtils.select(data, mask);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((double)d[2], (double)res.getDouble(0L), (double)1.0E-6);
        Assert.assertEquals((double)d[4], (double)res.getDouble(1L), (double)1.0E-6);
        Assert.assertEquals((double)d[5], (double)res.getDouble(2L), (double)1.0E-6);
        Assert.assertEquals((double)d[6], (double)res.getDouble(3L), (double)1.0E-6);
    }

    @Test
    public void testGenerateRandom() {
        int length = 10;
        LargeArray res = LargeArrayUtils.generateRandom(LargeArrayType.LOGIC, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.LOGIC), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.BYTE), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.UNSIGNED_BYTE, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.UNSIGNED_BYTE), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.SHORT, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.SHORT), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.INT, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.INT), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.LONG, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.LONG), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.DOUBLE), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_DOUBLE, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_DOUBLE), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.STRING, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.STRING), (Object)((Object)res.getType()));
        res = LargeArrayUtils.generateRandom(LargeArrayType.OBJECT, length);
        Assert.assertEquals((long)length, (long)res.length());
        Assert.assertEquals((Object)((Object)LargeArrayType.OBJECT), (Object)((Object)res.getType()));
    }
}

