/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import sun.misc.Cleaner;

public class FloatLargeArray
extends LargeArray {
    private static final long serialVersionUID = -8342458159338079576L;
    private float[] data;

    public FloatLargeArray(long length) {
        this(length, true);
    }

    public FloatLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.FLOAT;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        this.length = length;
        this.allocateMemory(zeroNativeMemory, 0.0f, false);
    }

    public FloatLargeArray(long length, float initValue) {
        this(length, initValue, false);
    }

    public FloatLargeArray(long length, float initValue, boolean createConstant) {
        this.type = LargeArrayType.FLOAT;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        this.length = length;
        this.allocateMemory(true, initValue, createConstant);
    }

    public FloatLargeArray(float[] data) {
        this.type = LargeArrayType.FLOAT;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public FloatLargeArray clone() {
        return (FloatLargeArray)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        boolean equal;
        if (o == null || !(o instanceof FloatLargeArray)) {
            return false;
        }
        FloatLargeArray la = (FloatLargeArray)o;
        boolean bl = equal = this.type == la.type && this.length == la.length;
        if (!equal) {
            return false;
        }
        if (this.parent != null && la.parent != null ? !this.parent.equals(la.parent) : this.parent != la.parent) {
            return false;
        }
        for (long i = 0L; i < this.length; ++i) {
            if (Float.compare(this.getFloat(i), la.getFloat(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(float quality) {
        int fprint = 29 * super.hashCode(quality);
        if (quality > 0.0f) {
            long step = (long)FastMath.ceil((double)((float)(1L - this.length) * quality + (float)this.length));
            for (long i = 0L; i < this.length; i += step) {
                fprint = 31 * fprint + Float.floatToIntBits(this.getFloat(i));
            }
        }
        return fprint;
    }

    @Override
    public final Float get(long i) {
        return Float.valueOf(this.getFloat(i));
    }

    @Override
    public final Float getFromNative(long i) {
        return Float.valueOf(LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i));
    }

    @Override
    public final boolean getBoolean(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i) != 0.0f;
        }
        if (this.isConstant) {
            return this.data[0] != 0.0f;
        }
        return this.data[(int)i] != 0.0f;
    }

    @Override
    public final byte getByte(long i) {
        if (this.ptr != 0L) {
            return (byte)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
        }
        if (this.isConstant) {
            return (byte)this.data[0];
        }
        return (byte)this.data[(int)i];
    }

    @Override
    public final short getUnsignedByte(long i) {
        if (this.ptr != 0L) {
            return (short)(0xFF & (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i));
        }
        if (this.isConstant) {
            return (short)(0xFF & (int)this.data[0]);
        }
        return (short)(0xFF & (int)this.data[(int)i]);
    }

    @Override
    public final short getShort(long i) {
        if (this.ptr != 0L) {
            return (short)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
        }
        if (this.isConstant) {
            return (short)this.data[0];
        }
        return (short)this.data[(int)i];
    }

    @Override
    public final int getInt(long i) {
        if (this.ptr != 0L) {
            return (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
        }
        if (this.isConstant) {
            return (int)this.data[0];
        }
        return (int)this.data[(int)i];
    }

    @Override
    public final long getLong(long i) {
        if (this.ptr != 0L) {
            return (long)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
        }
        if (this.isConstant) {
            return (long)this.data[0];
        }
        return (long)this.data[(int)i];
    }

    @Override
    public final float getFloat(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public final double getDouble(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    public final float[] getData() {
        return this.data;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                float v = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                out[i] = v != 0.0f;
                ++i;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0.0f;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i] != 0.0f;
                ++i;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                float v = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
                out[idx++] = v != 0.0f;
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != 0.0f;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                float v = this.data[(int)i];
                out[idx++] = v != 0.0f;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (byte)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (byte)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (byte)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (int)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (int)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (long)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (long)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (long)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            System.arraycopy(this.data, 0, out, 0, (int)this.length);
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.type.sizeOf() * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i, Object value) {
        LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, ((Float)value).floatValue());
    }

    @Override
    public final void setBoolean(long i, boolean value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, value ? 1.0f : 0.0f);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setBoolean(i, value);
        } else {
            this.data[(int)i] = value ? 1.0f : 0.0f;
        }
    }

    @Override
    public final void setByte(long i, byte value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setByte(i, value);
        } else {
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setUnsignedByte(long i, short value) {
        this.setShort(i, value);
    }

    @Override
    public final void setShort(long i, short value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setShort(i, value);
        } else {
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setInt(long i, int value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setInt(i, value);
        } else {
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setLong(long i, long value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setLong(i, value);
        } else {
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setFloat(long i, float value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setFloat(i, value);
        } else {
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setDouble(long i, double value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.type.sizeOf() * i, (float)value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getFloat(0L), false);
            this.isConstant = false;
            this.setDouble(i, value);
        } else {
            this.data[(int)i] = (float)value;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.data == null) {
            for (long i = 0L; i < this.length; ++i) {
                out.writeFloat(this.getFloat(i));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.type != LargeArrayType.FLOAT) {
            throw new IllegalArgumentException("Invalid array type");
        }
        if (this.length <= 0L) {
            throw new IllegalArgumentException("Non-positive array length");
        }
        if (this.data == null) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.type.sizeOf());
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.type.sizeOf()));
            MemoryCounter.increaseCounter(this.length * this.type.sizeOf());
            for (long i = 0L; i < this.length; ++i) {
                this.setFloat(i, in.readFloat());
            }
        }
    }

    private void allocateMemory(boolean initializeMemory, float initValue, boolean createConstant) {
        if (createConstant) {
            this.isConstant = true;
            this.data = new float[]{initValue};
        } else if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.type.sizeOf());
            if (initializeMemory) {
                this.initializeNativeMemory(this.length, Float.valueOf(initValue));
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.type.sizeOf()));
            MemoryCounter.increaseCounter(this.length * this.type.sizeOf());
        } else {
            this.data = new float[(int)this.length];
            if (initializeMemory && initValue != 0.0f) {
                Arrays.fill(this.data, initValue);
            }
        }
    }
}

