/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArrayTest;

public class ComplexDoubleLargeArrayTest
extends LargeArrayTest {
    public ComplexDoubleLargeArrayTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testEmptyComplexDoubleLargeArray() {
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(0L);
        Assert.assertEquals((long)0L, (long)a.length());
        ArrayIndexOutOfBoundsException e = null;
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        a = new ComplexDoubleLargeArray(0L, new double[]{1.0, 2.0}, true);
        Assert.assertEquals((long)0L, (long)a.length());
        Assert.assertTrue((boolean)a.isConstant());
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
    }

    @Test
    public void testComplexDoubleLargeArrayEqualsHashCode() {
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(10L);
        ComplexDoubleLargeArray b = new ComplexDoubleLargeArray(10L);
        Assert.assertTrue((boolean)a.equals(a));
        Assert.assertTrue((a.hashCode() == a.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == a.hashCode(1.0f) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals(b));
        Assert.assertTrue((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == b.hashCode(1.0f) ? 1 : 0) != 0);
        a.set(0L, new double[]{1.0, 2.0});
        Assert.assertFalse((boolean)a.equals(b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testComplexDoubleLargeArrayApproximateHashCode() {
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(10L);
        ComplexDoubleLargeArray b = new ComplexDoubleLargeArray(10L);
        a.setComplexDouble(0L, new double[]{1.0, 2.0});
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
        a = new ComplexDoubleLargeArray(10L, new double[]{1.0, 2.0}, true);
        b = new ComplexDoubleLargeArray(10L, new double[]{2.0, 3.0}, true);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() {
        Throwable throwable;
        ObjectInputStream in2;
        Throwable throwable2;
        ObjectOutputStream o2;
        Throwable throwable3;
        ByteArrayOutputStream bout;
        long size = 32L;
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(size);
        ComplexDoubleLargeArray b = null;
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (ComplexDoubleLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable in2) {
                    throwable2 = in2;
                    throw in2;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable in2) {
                                throwable2.addSuppressed(in2);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable o2) {
                throwable3 = o2;
                throw o2;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable o2) {
                            throwable3.addSuppressed(o2);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
        a = new ComplexDoubleLargeArray(size, new double[]{2.0, 3.0}, true);
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (ComplexDoubleLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
    }

    @Test
    public void testComplexDoubleLargeArrayConstant() {
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(10L, new double[]{2.5, 1.5}, true);
        Assert.assertTrue((boolean)a.isConstant());
        Assert.assertEquals((double)2.5, (double)a.getComplexDouble(0L)[0], (double)1.0E-6);
        Assert.assertEquals((double)1.5, (double)a.getComplexDouble(0L)[1], (double)1.0E-6);
        Assert.assertEquals((double)2.5, (double)a.getComplexDouble(a.length - 1L)[0], (double)1.0E-6);
        Assert.assertEquals((double)1.5, (double)a.getComplexDouble(a.length - 1L)[1], (double)1.0E-6);
        a.setComplexDouble(0L, new double[]{3.5, 4.5});
        Assert.assertFalse((boolean)a.isConstant());
        Assert.assertEquals((double)3.5, (double)a.getComplexDouble(0L)[0], (double)1.0E-6);
        Assert.assertEquals((double)4.5, (double)a.getComplexDouble(0L)[1], (double)1.0E-6);
    }

    @Test
    public void testComplexDoubleLargeArrayGetSet() {
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(10L);
        long idx = 5L;
        double[] val = new double[]{3.4, -3.7};
        a.setComplexDouble(idx, val);
        Assert.assertEquals((double)val[0], (double)a.getComplexDouble(idx)[0], (double)1.0E-6);
        Assert.assertEquals((double)val[1], (double)a.getComplexDouble(idx)[1], (double)1.0E-6);
        idx = 6L;
        a.set(idx, val);
        Assert.assertEquals((double)val[0], (double)a.get(idx)[0], (double)1.0E-6);
        Assert.assertEquals((double)val[1], (double)a.get(idx)[1], (double)1.0E-6);
    }

    @Test
    public void testComplexDoubleLargeArrayGetSetNative() {
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(10L);
        if (a.isLarge()) {
            long idx = 5L;
            double[] val = new double[]{3.4, -3.7};
            a.setToNative(idx, val);
            Assert.assertEquals((double)val[0], (double)a.getFromNative(idx)[0], (double)1.0E-6);
            Assert.assertEquals((double)val[1], (double)a.getFromNative(idx)[1], (double)1.0E-6);
        }
    }

    @Test
    public void testComplexDoubleLargeArrayGetData() {
        double[] data = new double[]{1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9, 10.1};
        int startPos = 1;
        int endPos = 5;
        int step = 2;
        ComplexDoubleLargeArray a = new ComplexDoubleLargeArray(data);
        double[] res = a.getComplexData(null, startPos, endPos, step);
        int idx = 0;
        for (int i = startPos; i < endPos; i += step) {
            Assert.assertEquals((double)data[2 * i], (double)res[2 * idx], (double)1.0E-6);
            Assert.assertEquals((double)data[2 * i + 1], (double)res[2 * idx + 1], (double)1.0E-6);
            ++idx;
        }
    }
}

