/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.UnsupportedEncodingException;
import java.util.TreeSet;
import org.jfree.fonts.ByteAccessUtilities;
import org.jfree.fonts.LanguageCode;
import org.jfree.fonts.truetype.FontTable;
import org.jfree.fonts.truetype.mappings.PlatformIdentifier;

public class NameTable
implements FontTable {
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FAMILY = 1;
    public static final int NAME_SUBFAMILY = 2;
    public static final int NAME_UNIQUE_SUBFAMILY = 3;
    public static final int NAME_FULLNAME = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_POSTSCRIPT = 6;
    public static final int NAME_TRADEMARK = 7;
    public static final int NAME_MANUFACTURER = 8;
    public static final int NAME_DESIGNER = 9;
    public static final int NAME_DESCRIPTION = 10;
    public static final int NAME_VENDOR_URL = 11;
    public static final int NAME_DESIGNER_URL = 12;
    public static final int NAME_LICENCE_DESCRIPTION = 13;
    public static final int NAME_LICENCE_URL = 14;
    public static final int NAME_RESERVED = 15;
    public static final int NAME_PREFERRED_FAMILY = 16;
    public static final int NAME_PREFERRED_SUBFAMILY = 17;
    public static final int NAME_COMPATIBLE_FULL = 18;
    public static final int NAME_SAMPLE_TEXT = 19;
    public static final long TABLE_ID = 1851878757L;
    private int format = 0;
    private int recordCount;
    private int stringOffset;
    private NameRecord[] names;

    public NameTable(byte[] buffer) throws UnsupportedEncodingException {
        this.recordCount = ByteAccessUtilities.readUShort(buffer, 2);
        this.stringOffset = ByteAccessUtilities.readUShort(buffer, 4);
        this.names = new NameRecord[this.recordCount];
        int i = 0;
        while (i < this.recordCount) {
            this.names[i] = new NameRecord(buffer, 6 + i * 12, this.stringOffset);
            ++i;
        }
    }

    public String[] getAllNames(int type) {
        TreeSet<String> retvalCollector = new TreeSet<String>();
        int i = 0;
        while (i < this.names.length) {
            NameRecord name = this.names[i];
            if (name.getNameId() == type) {
                retvalCollector.add(name.getName());
            }
            ++i;
        }
        return retvalCollector.toArray(new String[retvalCollector.size()]);
    }

    public int getFormat() {
        return this.format;
    }

    public long getName() {
        return 1851878757L;
    }

    public String getName(int type, LanguageCode language) {
        int i = 0;
        while (i < this.names.length) {
            NameRecord name = this.names[i];
            if (name.getNameId() == type && name.getLanguageId() == language.getCode()) {
                return name.getName();
            }
            ++i;
        }
        return null;
    }

    public String getName(int type, PlatformIdentifier platformId, int platformEncoding, int rawLanguage) {
        int i = 0;
        while (i < this.names.length) {
            NameRecord name = this.names[i];
            if (name.getPlatformId().equals(platformId) && name.getPlatformEncodingId() == platformEncoding && name.getLanguageId() == rawLanguage && name.getNameId() == type) {
                return name.getName();
            }
            ++i;
        }
        return null;
    }

    public NameRecord getNameRecord(int pos) {
        return this.names[pos];
    }

    public NameRecord[] getNameRecords() {
        return (NameRecord[])this.names.clone();
    }

    public String getPrimaryName(int type) {
        String unicodeFallback = null;
        int i = 0;
        while (i < this.names.length) {
            NameRecord name = this.names[i];
            if (name.getNameId() == type) {
                if (name.getPlatformId().equals(PlatformIdentifier.MACINTOSH) && name.getLanguageId() == LanguageCode.MacLanguageCode.ENGLISH.getCode()) {
                    return name.getName();
                }
                if (name.getPlatformId().equals(PlatformIdentifier.MICROSOFT) && name.getLanguageId() == LanguageCode.MicrosoftLanguageCode.ENGLISH_US.getCode()) {
                    return name.getName();
                }
                if (name.getPlatformId().equals(PlatformIdentifier.UNICODE)) {
                    unicodeFallback = name.getName();
                }
                if (unicodeFallback != null) {
                    unicodeFallback = name.getName();
                }
            }
            ++i;
        }
        return unicodeFallback;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getStringOffset() {
        return this.stringOffset;
    }

    public static class NameRecord {
        private PlatformIdentifier platformId;
        private int platformEncodingId;
        private int languageId;
        private int nameId;
        private String name;

        public NameRecord(byte[] data, int recordOffset, int stringOffset) throws UnsupportedEncodingException {
            this.platformId = PlatformIdentifier.getIdentifier(ByteAccessUtilities.readUShort(data, recordOffset));
            this.platformEncodingId = ByteAccessUtilities.readUShort(data, recordOffset + 2);
            this.languageId = ByteAccessUtilities.readUShort(data, recordOffset + 4);
            this.nameId = ByteAccessUtilities.readUShort(data, recordOffset + 6);
            int length = ByteAccessUtilities.readUShort(data, recordOffset + 8);
            int offset = ByteAccessUtilities.readUShort(data, recordOffset + 10);
            this.name = ByteAccessUtilities.readString(data, stringOffset + offset, length, this.platformId.getEncoding(this.platformEncodingId, this.languageId));
        }

        public int getLanguageId() {
            return this.languageId;
        }

        public String getName() {
            return this.name;
        }

        public int getNameId() {
            return this.nameId;
        }

        public int getPlatformEncodingId() {
            return this.platformEncodingId;
        }

        public PlatformIdentifier getPlatformId() {
            return this.platformId;
        }
    }
}

