/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.tools;

import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.truetype.TrueTypeFontRegistry;

public class ListFonts {
    private ListFonts() {
    }

    public static void main(String[] args) {
        TrueTypeFontRegistry registry = new TrueTypeFontRegistry();
        registry.initialize();
        String[] fontFamilies = registry.getRegisteredFamilies();
        int i = 0;
        while (i < fontFamilies.length) {
            String fontFamily = fontFamilies[i];
            FontFamily family = registry.getFontFamily(fontFamily);
            String[] names = family.getAllNames();
            int j = 0;
            while (j < names.length) {
                String name = names[j];
                System.out.println("  Alias: " + j + " Name:" + name);
                ++j;
            }
            ++i;
        }
    }

    private static void printRecord(FontRecord record) {
        if (record == null) {
            System.out.println("  - (there is no font defined for that style and family.)");
            return;
        }
        System.out.println("  " + record.getName() + " italics:" + record.isItalic() + " oblique:" + record.isOblique());
        String[] allNames = record.getAllNames();
        int i = 0;
        while (i < allNames.length) {
            String name = allNames[i];
            System.out.println("  Alias: " + i + " Name:" + name);
            ++i;
        }
        String[] allVariants = record.getAllVariants();
        int i2 = 0;
        while (i2 < allVariants.length) {
            String name = allVariants[i2];
            System.out.println("  Variant: " + i2 + " Name:" + name);
            ++i2;
        }
    }
}

