/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jfree.fonts.io.FontDataInputSource;

public class FileFontDataInputSource
implements FontDataInputSource {
    private File file;
    private RandomAccessFile fileReader;
    private long lastPosition;

    public FileFontDataInputSource(File file) throws IOException {
        this.file = file;
        this.fileReader = new RandomAccessFile(file, "r");
    }

    public synchronized void dispose() {
        if (this.fileReader == null) {
            return;
        }
        try {
            this.fileReader.close();
        }
        catch (IOException iOException) {}
        this.fileReader = null;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file.getPath();
    }

    public synchronized void readFullyAt(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            this.fileReader.seek(position);
        } else if (position != this.lastPosition) {
            this.fileReader.seek(position);
        }
        this.fileReader.readFully(buffer, offset, length);
        this.lastPosition = position + (long)length;
    }
}

