/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.variable;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.gui.plot.MatrixPlot;
import org.ujmp.gui.renderer.MatrixHeatmapRenderer;

public class VariableTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 990917492575992066L;
    private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    private final MatrixHeatmapRenderer matrixRenderer = new MatrixHeatmapRenderer();
    private final MatrixPlot matrixPlot = new MatrixPlot();
    private Variable variable = null;
    private Object o = null;

    public VariableTableCellRenderer() {
        this.matrixPlot.getPlotSettings().setShowXAxis(false);
        this.matrixPlot.getPlotSettings().setShowYAxis(false);
        this.matrixPlot.getPlotSettings().setShowXGrid(false);
        this.matrixPlot.getPlotSettings().setShowYGrid(false);
        this.matrixPlot.getPlotSettings().setTimeLimit(10L);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel l = null;
        this.variable = value instanceof Variable ? (Variable)value : null;
        if (this.variable != null) {
            switch (column) {
                case 0: {
                    this.o = this.variable.getId();
                    break;
                }
                case 1: {
                    this.o = this.variable.getLabel();
                    break;
                }
                case 5: {
                    this.o = this.variable.size();
                    break;
                }
                case 2: {
                    if (!this.variable.isEmpty()) {
                        Matrix m = (Matrix)this.variable.getLast();
                        if (m != null) {
                            this.o = "" + m.getRowCount() + "x" + m.getColumnCount();
                            break;
                        }
                        this.o = "0x0";
                        break;
                    }
                    this.o = "0x0";
                    break;
                }
                case 4: {
                    if (!this.variable.isEmpty()) {
                        return this.matrixPlot.getTableCellRendererComponent(table, this.variable.getLast(), isSelected, hasFocus, row, column);
                    }
                    return this.matrixPlot.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
                }
                case 3: {
                    if (!this.variable.isEmpty()) {
                        return this.matrixRenderer.getTableCellRendererComponent(table, this.variable.getLast(), isSelected, hasFocus, row, column);
                    }
                    return this.matrixRenderer.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
                }
                default: {
                    this.o = null;
                }
            }
            l = (JLabel)this.renderer.getTableCellRendererComponent(table, this.o, isSelected, hasFocus, row, column);
            l.setHorizontalAlignment(0);
        }
        return l;
    }
}

