/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.sample;

import java.util.Collection;
import org.jdmp.core.sample.AbstractSampleFactory;
import org.jdmp.core.sample.DefaultSample;
import org.jdmp.core.sample.RelationalSample;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;

public class DefaultSampleFactory
extends AbstractSampleFactory {
    @Override
    public final Sample labeledSample(String label) {
        DefaultSample s = new DefaultSample();
        s.setLabel(label);
        return s;
    }

    @Override
    public final Sample linkToMatrix(Matrix input) {
        DefaultSample s = new DefaultSample();
        s.put("Input", input);
        s.setLabel(input.getLabel());
        return s;
    }

    @Override
    public final Sample classificationSample(Matrix input, Matrix target) {
        DefaultSample s = new DefaultSample();
        s.put("Input", input);
        s.put("Target", target);
        return s;
    }

    @Override
    public final Sample classificationSample(Matrix input, int classId, int classCount) {
        DefaultSample s = new DefaultSample();
        s.put("Input", input);
        DenseMatrix target = Matrix.Factory.zeros(1L, (long)classCount);
        target.setAsDouble(1.0, 0L, classId);
        s.put("Target", target);
        return s;
    }

    @Override
    public final Sample classificationSample(Matrix input, boolean target) {
        return this.classificationSample(input, target ? 1 : 0, 2);
    }

    @Override
    public final Sample emptySample() {
        return new DefaultSample();
    }

    @Override
    public final RelationalSample relationalSample(Collection<?> items) {
        RelationalSample s = new RelationalSample();
        for (Object o : items) {
            s.addObject(o);
        }
        return s;
    }

    @Override
    public final RelationalSample relationalSample(String label) {
        RelationalSample s = new RelationalSample();
        s.setLabel(label);
        return s;
    }

    @Override
    public Sample clone(Sample s) {
        Sample ret = Sample.Factory.emptySample();
        ret.setLabel(s.getLabel());
        ret.setDescription(s.getDescription());
        for (String k : s.keySet()) {
            Matrix v = s.getAsMatrix(k);
            if (v == null) continue;
            ret.put(k, v.clone());
        }
        return ret;
    }
}

