/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.dataset;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.jdmp.core.dataset.DataSet;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.listmatrix.AbstractListMatrix;
import org.ujmp.core.util.MathUtil;

public abstract class AbstractListDataSet
extends AbstractListMatrix<Sample>
implements ListDataSet {
    private static final long serialVersionUID = -4168834188998259018L;

    public AbstractListDataSet() {
        this.setId("DataSet" + this.getCoreObjectId());
    }

    @Override
    public final Matrix getInputMatrix() {
        Matrix input = this.getMatrix("Input");
        if (input == null) {
            FastArrayList<Matrix> matrices = new FastArrayList<Matrix>();
            for (Sample s : this) {
                matrices.add(s.getAsMatrix("Input"));
            }
            input = Matrix.Factory.vertCat(Calculation.Ret.LINK, matrices);
            this.getMetaData().put("Input", input);
        }
        return input;
    }

    @Override
    public final Matrix getPredictedMatrix() {
        Matrix predicted = this.getMatrix("Predicted");
        if (predicted == null) {
            FastArrayList<Matrix> matrices = new FastArrayList<Matrix>();
            for (Sample s : this) {
                matrices.add(s.getAsMatrix("Predicted"));
            }
            predicted = Matrix.Factory.vertCat(Calculation.Ret.LINK, matrices);
            this.getMetaData().put("Predicted", predicted);
        }
        return predicted;
    }

    @Override
    public final Matrix getTargetMatrix() {
        Matrix target = this.getMatrix("Target");
        if (target == null) {
            FastArrayList<Matrix> matrices = new FastArrayList<Matrix>();
            for (Sample s : this) {
                matrices.add(s.getAsMatrix("Target"));
            }
            target = Matrix.Factory.vertCat(Calculation.Ret.LINK, matrices);
            this.getMetaData().put("Target", target);
        }
        return target;
    }

    @Override
    public final List<ListDataSet> splitByCount(boolean shuffle, int ... count) {
        ArrayList<ListDataSet> dataSets = new ArrayList<ListDataSet>();
        FastArrayList<Sample> all = new FastArrayList<Sample>();
        all.addAll(this);
        for (int i = 0; i < count.length; ++i) {
            AbstractListDataSet ds = DataSet.Factory.labeledDataSet("DataSet" + i);
            for (int c = 0; c < count[i]; ++c) {
                if (shuffle) {
                    ds.add(all.remove(MathUtil.nextInteger(all.size())));
                    continue;
                }
                ds.add(all.remove(0));
            }
            dataSets.add(ds);
        }
        AbstractListDataSet ds = DataSet.Factory.labeledDataSet("DataSet" + count.length);
        ds.addAll(all);
        dataSets.add(ds);
        return dataSets;
    }

    @Override
    public final List<ListDataSet> splitForCV(int numberOfCVSets, int idOfCVSet, long randomSeed) {
        int set;
        ArrayList<ListDataSet> returnDataSets = new ArrayList<ListDataSet>();
        ArrayList tempSampleLists = new ArrayList();
        ArrayList<Sample> allSamples = new ArrayList<Sample>(this);
        Collections.shuffle(allSamples, new Random(randomSeed));
        for (set = 0; set < numberOfCVSets; ++set) {
            ArrayList partSamples = new ArrayList();
            tempSampleLists.add(partSamples);
        }
        while (!allSamples.isEmpty()) {
            for (set = 0; set < numberOfCVSets; ++set) {
                if (allSamples.isEmpty()) continue;
                ((List)tempSampleLists.get(set)).add(allSamples.remove(0));
            }
        }
        AbstractListDataSet testSet = DataSet.Factory.labeledDataSet("TestSet" + randomSeed + "-" + idOfCVSet);
        testSet.addAll((Collection)tempSampleLists.get(idOfCVSet));
        AbstractListDataSet trainingSet = DataSet.Factory.labeledDataSet("TrainingSet" + randomSeed + "-" + idOfCVSet);
        for (int i = 0; i < numberOfCVSets; ++i) {
            if (i == idOfCVSet) continue;
            trainingSet.addAll((Collection)tempSampleLists.get(i));
        }
        returnDataSets.add(trainingSet);
        returnDataSets.add(testSet);
        return returnDataSets;
    }

    @Override
    public final List<ListDataSet> splitByPercent(boolean shuffle, double ... percent) {
        int[] counts = new int[percent.length];
        int sampleCount = this.size();
        for (int i = 0; i < percent.length; ++i) {
            counts[i] = (int)Math.round(percent[i] * (double)sampleCount);
        }
        return this.splitByCount(shuffle, counts);
    }

    @Override
    public final String toString() {
        if (this.getLabel() == null) {
            return this.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName() + " [" + this.getLabel() + "]";
    }

    @Override
    public final GUIObject getGUIObject() {
        if (this.guiObject == null) {
            try {
                Constructor<?> con = null;
                Class<?> c = Class.forName("org.jdmp.gui.dataset.DataSetGUIObject");
                con = c.getConstructor(ListDataSet.class);
                this.guiObject = (GUIObject)con.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.guiObject;
    }

    @Override
    public abstract ListDataSet clone();

    @Override
    public final Matrix getMatrix(Object key) {
        return this.getMetaDataMatrix(key);
    }

    @Override
    public final Set<String> keySet() {
        return this.getMetaData().keySet();
    }

    @Override
    public final void setMatrix(String key, Matrix matrix) {
        this.setMetaData(key, matrix);
    }

    @Override
    public final double getAsDouble(String key) {
        return this.getMetaDataDouble(key);
    }

    @Override
    public final ListDataSet bootstrap(int numberOfSamples) {
        AbstractListDataSet ds = DataSet.Factory.labeledDataSet("Bootstrap of " + this.getLabel());
        for (int i = 0; i < numberOfSamples; ++i) {
            int rand = MathUtil.nextInteger(0, this.size());
            ds.add(this.get(rand));
        }
        return ds;
    }

    @Override
    public final boolean isDiscrete() {
        for (Sample s : this) {
            Matrix input = s.getAsMatrix("Input");
            for (long[] c : input.availableCoordinates()) {
                if (MathUtil.isDiscrete(input.getAsDouble(c))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final int getFeatureCount() {
        return (int)((Sample)this.get(0)).getAsMatrix("Input").toColumnVector(Calculation.Ret.LINK).getColumnCount();
    }

    @Override
    public final ListDataSet bootstrap() {
        return this.bootstrap(this.size());
    }

    public final Matrix getClassDistribution() {
        DenseMatrix m = Matrix.Factory.zeros((long)this.getClassCount(), 1L);
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (Sample s : this) {
            int c = s.getTargetClass();
            Double d = (Double)map.get(c);
            if (d == null) {
                d = 0.0;
            }
            Double d2 = d;
            Double d3 = d = Double.valueOf(d + 1.0);
            map.put(c, d);
        }
        for (int i = 0; i < this.getClassCount(); ++i) {
            Double d = (Double)map.get(i);
            if (d == null) {
                d = 0.0;
            }
            m.setAsDouble(d / (double)this.size(), i, 0L);
        }
        return m;
    }

    public final void appendRMSEMatrix(Matrix m) {
        this.setMatrix("RMSE", m);
    }

    public final double getRMSE() {
        Matrix m = this.getRMSEMatrix();
        if (m == null) {
            return Double.NaN;
        }
        return m.getEuklideanValue();
    }

    public final Matrix getRMSEMatrix() {
        return this.getMatrix("RMSE");
    }

    @Override
    public final int getClassCount() {
        return (int)((Sample)this.get(0)).getAsMatrix("Target").toColumnVector(Calculation.Ret.LINK).getColumnCount();
    }

    @Override
    public final int getErrorCount() {
        return (int)this.getMetaDataDouble("ErrorCount");
    }

    @Override
    public final double getAccuracy() {
        return this.getMetaDataDouble("Accuracy");
    }

    public final List<ListDataSet> splitByClass() {
        ArrayList<ListDataSet> returnDataSets = new ArrayList<ListDataSet>();
        for (int i = 0; i < this.getClassCount(); ++i) {
            AbstractListDataSet ds = DataSet.Factory.labeledDataSet("Class " + i);
            for (Sample s : this) {
                if (s.getTargetClass() != i) continue;
                ds.add(s.clone());
            }
            returnDataSets.add(ds);
        }
        return returnDataSets;
    }

    @Override
    public final List<ListDataSet> splitForStratifiedCV(int numberOfCVSets, int idOfCVSet, long randomSeed) {
        ArrayList<ListDataSet> returnDataSets = new ArrayList<ListDataSet>();
        Random rand = new Random(randomSeed);
        int classCount = this.getClassCount();
        ArrayList<List<Sample>> sortedSamples = new ArrayList<List<Sample>>();
        for (int i = 0; i < classCount; ++i) {
            sortedSamples.add(new ArrayList());
        }
        for (Sample s : this) {
            int targetClass = s.getTargetClass();
            ((List)sortedSamples.get(targetClass)).add(s);
        }
        Collections.shuffle(sortedSamples, rand);
        for (int i = 0; i < classCount; ++i) {
            Collections.shuffle((List)sortedSamples.get(i), rand);
        }
        ArrayList cvSets = new ArrayList();
        for (int cvSet = 0; cvSet < numberOfCVSets; ++cvSet) {
            ArrayList samples = new ArrayList();
            cvSets.add(samples);
        }
        int fromPointer = 0;
        int toPointer = 0;
        while (!AbstractListDataSet.allEmpty(sortedSamples)) {
            for (toPointer = 0; toPointer < cvSets.size(); ++toPointer) {
                List to = (List)cvSets.get(toPointer);
                while ((double)to.size() < (double)this.size() / (double)numberOfCVSets && fromPointer < sortedSamples.size()) {
                    List from = (List)sortedSamples.get(fromPointer);
                    if (!from.isEmpty()) {
                        to.add(from.remove(0));
                    }
                    ++fromPointer;
                }
                fromPointer = 0;
            }
        }
        AbstractListDataSet train = DataSet.Factory.labeledDataSet("TrainingSet " + idOfCVSet + "/" + numberOfCVSets + "(" + randomSeed + ")");
        AbstractListDataSet test = DataSet.Factory.labeledDataSet("TestSet " + idOfCVSet + "/" + numberOfCVSets + "(" + randomSeed + ")");
        test.addAll((Collection)cvSets.remove(idOfCVSet));
        for (List list : cvSets) {
            train.addAll(list);
        }
        returnDataSets.add(train);
        returnDataSets.add(test);
        return returnDataSets;
    }

    private static final boolean allEmpty(List<List<Sample>> lists) {
        for (List<Sample> list : lists) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

