/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.hashing;

import org.jdmp.core.algorithm.hashing.AbstractHashing;
import org.jdmp.core.dataset.ListDataSet;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;

public class HashRandomProjection
extends AbstractHashing {
    private static final long serialVersionUID = 2795551342148850378L;
    private final int numberOfBits;
    Matrix randomVectors = null;

    public HashRandomProjection(int numberOfBits) {
        this.numberOfBits = numberOfBits;
    }

    @Override
    public void reset() {
        this.randomVectors.clear();
    }

    @Override
    public void train(ListDataSet dataSet) {
        int featureCount = dataSet.getFeatureCount();
        this.randomVectors = Matrix.Factory.randn((long)featureCount, (long)this.numberOfBits);
    }

    @Override
    public Matrix hash(Matrix input) {
        Matrix result = input.toColumnVector(Calculation.Ret.NEW).mtimes(this.randomVectors).ge(Calculation.Ret.NEW, 0.0);
        return result;
    }
}

