/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.classification;

import org.jdmp.core.algorithm.classification.AbstractClassifier;
import org.jdmp.core.algorithm.classification.Classifier;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;

public class RandomClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = -8043103888877795342L;
    private int classCount = 0;

    @Override
    public Matrix predictOne(Matrix input) {
        return Matrix.Factory.rand(1L, (long)this.classCount);
    }

    @Override
    public void reset() {
        this.classCount = 0;
    }

    @Override
    public void trainAll(ListDataSet dataSet) {
        for (Sample s : dataSet) {
            Matrix m = s.getAsMatrix("Target");
            this.classCount = (int)Math.max((long)this.classCount, m.getColumnCount());
        }
    }

    @Override
    public Classifier emptyCopy() {
        return new RandomClassifier();
    }
}

