/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.algorithm.classification.mlp.MultiLayerNetwork;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.util.MathUtil;

public class CreateMLP
extends AbstractAlgorithm {
    private static final long serialVersionUID = -5372885309350915607L;
    public static final String DESCRIPTION = "creates a MultiLayerPerceptron";
    public static final String HIDDEN1 = "Hidden1";
    public static final String HIDDEN2 = "Hidden2";
    public static final String HIDDEN3 = "Hidden3";

    public CreateMLP(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey(HIDDEN1);
        this.addVariableKey(HIDDEN2);
        this.addVariableKey(HIDDEN3);
        this.addVariableKey("Target");
        this.setEdgeLabel(HIDDEN1, "neurons in hidden layer 1");
        this.setEdgeLabel(HIDDEN2, "neurons in hidden layer 2");
        this.setEdgeLabel(HIDDEN3, "neurons in hidden layer 3");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection(HIDDEN1, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(HIDDEN2, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(HIDDEN3, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object h1 = input.get(HIDDEN1);
        Object h2 = input.get(HIDDEN2);
        Object h3 = input.get(HIDDEN3);
        int[] hidden = null;
        hidden = h3 != null ? new int[]{MathUtil.getInt(h1), MathUtil.getInt(h2), MathUtil.getInt(h3)} : (h2 != null ? new int[]{MathUtil.getInt(h1), MathUtil.getInt(h2)} : (h1 != null ? new int[]{MathUtil.getInt(h1)} : new int[]{}));
        result.put("Target", new MultiLayerNetwork(hidden));
        return result;
    }
}

