/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core;

import java.applet.Applet;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import org.jdmp.core.module.Module;
import org.jdmp.core.module.ModuleFactory;
import org.jdmp.core.script.Result;
import org.ujmp.core.util.io.IntelligentFileReader;

public class JDMP
extends Applet {
    private static final long serialVersionUID = -6039550773857594839L;
    public static final String JDMPVERSION = "0.3.0";
    public static final String UJMPVERSION = "0.3.0";
    public static final String AUTHOR = "Holger Arndt";
    public static final String COPYRIGHT = "2008-2015";
    protected static final PrintStream out = System.out;
    protected static String script = null;
    protected static String file = null;
    protected static boolean textMode = true;

    public static void main(String[] args) throws Exception {
        JDMP.evaluateParameters(args);
        JDMP.run();
    }

    protected static void evaluateParameters(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-e") || args[i].equals("--execute")) {
                    if ((script = args[++i]).startsWith("\"")) {
                        script = script.substring(1);
                    }
                    if (!script.endsWith("\"")) continue;
                    script = script.substring(1, script.length() - 1);
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--file")) {
                    file = args[++i];
                    continue;
                }
                if (args[i].equals("-g") || args[i].equals("--gui")) {
                    textMode = false;
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--text")) {
                    textMode = true;
                    continue;
                }
                if (!args[i].equals("-h") && !args[i].equals("--help")) continue;
                JDMP.help();
                System.exit(0);
            }
        }
        catch (Exception e) {
            JDMP.help();
            System.exit(1);
        }
    }

    private static void help() {
        out.println();
        out.println("JDMP supports the following command line options:");
        out.println("    JDMP [-tgh] [-e command] [-f file]");
        out.println();
        out.println("    -e, --execute     executes a command at startup");
        out.println("    -f, --file        executes the commands in the specified file");
        out.println("    -t, --text        starts JDMP in textmode");
        out.println("    -g, --gui         starts JDMP in graphics mode");
        out.println("    -h, --help        displays this help text");
        out.println();
        out.println();
    }

    public static void run() throws Exception {
        out.println("/*");
        out.println(" * Welcome to the Java Data Mining Package (JDMP) v0.3.0");
        out.println(" * Copyright (C) 2008-2015 by Holger Arndt");
        out.println(" *");
        out.println(" * JDMP is free software; you can redistribute it and/or modify");
        out.println(" * it under the terms of the GNU Lesser General Public License as");
        out.println(" * published by the Free Software Foundation; either version 2");
        out.println(" * of the License, or (at your option) any later version.");
        out.println(" *");
        out.println(" * JDMP is distributed in the hope that it will be useful,");
        out.println(" * but WITHOUT ANY WARRANTY; without even the implied warranty of");
        out.println(" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the");
        out.println(" * GNU Lesser General Public License for more details.");
        out.println(" *");
        out.println(" * If you would like to find out more, please take a look at the");
        out.println(" * homepage of JDMP at https://jdmp.org/");
        out.println(" */");
        out.println();
        Module module = ModuleFactory.emptyModule();
        if (!textMode) {
            try {
                Class.forName("org.jdmp.gui.JDMP");
                module.showGUI();
            }
            catch (Exception e) {
                out.println("Graphics mode is not available, probably because jdmp-gui is not");
                out.println("in the class path.");
                out.println();
                textMode = true;
            }
        }
        if (file != null) {
            String script = IntelligentFileReader.load(file);
            module.execute(script);
        }
        if (script != null) {
            module.execute(script);
        }
        if (textMode) {
            LineNumberReader lr = new LineNumberReader(new InputStreamReader(System.in));
            while (true) {
                try {
                    while (true) {
                        out.print(">> ");
                        String line = lr.readLine();
                        if (line.startsWith(">> ")) {
                            line = line.substring(3);
                        }
                        if (!line.endsWith(";")) {
                            Result result = module.execute(line + ";");
                            out.println(result);
                            continue;
                        }
                        module.execute(line);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

